/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateJobRequest extends SnowballRequest implements ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private final String jobType;

    private final JobResource resources;

    private final String description;

    private final String addressId;

    private final String kmsKeyARN;

    private final String roleARN;

    private final String snowballCapacityPreference;

    private final String shippingOption;

    private final Notification notification;

    private final String clusterId;

    private final String snowballType;

    private final String forwardingAddressId;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.clusterId = builder.clusterId;
        this.snowballType = builder.snowballType;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * Defines the type of job that you're creating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Defines the type of job that you're creating.
     * @see JobType
     */
    public JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * Defines the type of job that you're creating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Defines the type of job that you're creating.
     * @see JobType
     */
    public String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * Defines the Amazon S3 buckets associated with this job.
     * </p>
     * <p>
     * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
     * into.
     * </p>
     * <p>
     * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
     * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define
     * the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
     * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
     * </p>
     * 
     * @return Defines the Amazon S3 buckets associated with this job.</p>
     *         <p>
     *         With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
     *         imported into.
     *         </p>
     *         <p>
     *         With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
     *         exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a
     *         range, you define the length of the range by providing either an inclusive <code>BeginMarker</code>
     *         value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
     * </p>
     * 
     * @return Defines an optional description of this specific job, for example
     *         <code>Important Photos 2016-08-11</code>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID for the address that you want the Snowball shipped to.
     * </p>
     * 
     * @return The ID for the address that you want the Snowball shipped to.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using
     * the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> AWS Key
     * Management Service (KMS) API action.
     * </p>
     * 
     * @return The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created
     *         using the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a>
     *         AWS Key Management Service (KMS) API action.
     */
    public String kmsKeyARN() {
        return kmsKeyARN;
    }

    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a
     * href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> AWS Identity and
     * Access Management (IAM) API action.
     * </p>
     * 
     * @return The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created
     *         using the <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>
     *         AWS Identity and Access Management (IAM) API action.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snowball you'd
     * like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return If your job is being created in one of the US regions, you have the option of specifying what size
     *         Snowball you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * @see SnowballCapacity
     */
    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(snowballCapacityPreference);
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snowball you'd
     * like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceAsString}.
     * </p>
     * 
     * @return If your job is being created in one of the US regions, you have the option of specifying what size
     *         Snowball you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * @see SnowballCapacity
     */
    public String snowballCapacityPreferenceAsString() {
        return snowballCapacityPreference;
    }

    /**
     * <p>
     * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
     * represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snowballs are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
     *         represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds
     *         are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
     *         about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     *         delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
     *         typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snowballs are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(shippingOption);
    }

    /**
     * <p>
     * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
     * represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snowballs are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
     *         represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds
     *         are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
     *         about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     *         delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
     *         typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snowballs are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public String shippingOptionAsString() {
        return shippingOption;
    }

    /**
     * <p>
     * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
     * </p>
     * 
     * @return Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
     * <code>clusterId</code> value. The other job attributes are inherited from the cluster.
     * </p>
     * 
     * @return The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
     *         <code>clusterId</code> value. The other job attributes are inherited from the cluster.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for cluster
     * jobs is <code>EDGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for
     *         cluster jobs is <code>EDGE</code>.
     * @see SnowballType
     */
    public SnowballType snowballType() {
        return SnowballType.fromValue(snowballType);
    }

    /**
     * <p>
     * The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for cluster
     * jobs is <code>EDGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snowballType} will
     * return {@link SnowballType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snowballTypeAsString}.
     * </p>
     * 
     * @return The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for
     *         cluster jobs is <code>EDGE</code>.
     * @see SnowballType
     */
    public String snowballTypeAsString() {
        return snowballType;
    }

    /**
     * <p>
     * The forwarding address ID for a job. This field is not supported in most regions.
     * </p>
     * 
     * @return The forwarding address ID for a job. This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(addressId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(snowballCapacityPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingAddressId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(resources(), other.resources())
                && Objects.equals(description(), other.description()) && Objects.equals(addressId(), other.addressId())
                && Objects.equals(kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString())
                && Objects.equals(shippingOptionAsString(), other.shippingOptionAsString())
                && Objects.equals(notification(), other.notification()) && Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(snowballTypeAsString(), other.snowballTypeAsString())
                && Objects.equals(forwardingAddressId(), other.forwardingAddressId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateJobRequest").add("JobType", jobTypeAsString()).add("Resources", resources())
                .add("Description", description()).add("AddressId", addressId()).add("KmsKeyARN", kmsKeyARN())
                .add("RoleARN", roleARN()).add("SnowballCapacityPreference", snowballCapacityPreferenceAsString())
                .add("ShippingOption", shippingOptionAsString()).add("Notification", notification())
                .add("ClusterId", clusterId()).add("SnowballType", snowballTypeAsString())
                .add("ForwardingAddressId", forwardingAddressId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobType":
            return Optional.of(clazz.cast(jobTypeAsString()));
        case "Resources":
            return Optional.of(clazz.cast(resources()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "AddressId":
            return Optional.of(clazz.cast(addressId()));
        case "KmsKeyARN":
            return Optional.of(clazz.cast(kmsKeyARN()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "SnowballCapacityPreference":
            return Optional.of(clazz.cast(snowballCapacityPreferenceAsString()));
        case "ShippingOption":
            return Optional.of(clazz.cast(shippingOptionAsString()));
        case "Notification":
            return Optional.of(clazz.cast(notification()));
        case "ClusterId":
            return Optional.of(clazz.cast(clusterId()));
        case "SnowballType":
            return Optional.of(clazz.cast(snowballTypeAsString()));
        case "ForwardingAddressId":
            return Optional.of(clazz.cast(forwardingAddressId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnowballRequest.Builder, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * Defines the type of job that you're creating.
         * </p>
         * 
         * @param jobType
         *        Defines the type of job that you're creating.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Defines the type of job that you're creating.
         * </p>
         * 
         * @param jobType
         *        Defines the type of job that you're creating.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * Defines the Amazon S3 buckets associated with this job.
         * </p>
         * <p>
         * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
         * into.
         * </p>
         * <p>
         * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
         * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you
         * define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
         * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * 
         * @param resources
         *        Defines the Amazon S3 buckets associated with this job.</p>
         *        <p>
         *        With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
         *        imported into.
         *        </p>
         *        <p>
         *        With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
         *        exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export
         *        a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code>
         *        value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * Defines the Amazon S3 buckets associated with this job.
         * </p>
         * <p>
         * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
         * into.
         * </p>
         * <p>
         * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
         * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you
         * define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
         * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * This is a convenience that creates an instance of the {@link JobResource.Builder} avoiding the need to create
         * one manually via {@link JobResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobResource.Builder#build()} is called immediately and its result
         * is passed to {@link #resources(JobResource)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link JobResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(JobResource)
         */
        default Builder resources(Consumer<JobResource.Builder> resources) {
            return resources(JobResource.builder().apply(resources).build());
        }

        /**
         * <p>
         * Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
         * </p>
         * 
         * @param description
         *        Defines an optional description of this specific job, for example
         *        <code>Important Photos 2016-08-11</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID for the address that you want the Snowball shipped to.
         * </p>
         * 
         * @param addressId
         *        The ID for the address that you want the Snowball shipped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created
         * using the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> AWS
         * Key Management Service (KMS) API action.
         * </p>
         * 
         * @param kmsKeyARN
         *        The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are
         *        created using the <a
         *        href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> AWS Key
         *        Management Service (KMS) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyARN(String kmsKeyARN);

        /**
         * <p>
         * The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using
         * the <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> AWS
         * Identity and Access Management (IAM) API action.
         * </p>
         * 
         * @param roleARN
         *        The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created
         *        using the <a
         *        href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> AWS
         *        Identity and Access Management (IAM) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * If your job is being created in one of the US regions, you have the option of specifying what size Snowball
         * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        If your job is being created in one of the US regions, you have the option of specifying what size
         *        Snowball you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(String snowballCapacityPreference);

        /**
         * <p>
         * If your job is being created in one of the US regions, you have the option of specifying what size Snowball
         * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        If your job is being created in one of the US regions, you have the option of specifying what size
         *        Snowball you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference);

        /**
         * <p>
         * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
         * represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are
         * as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowballs are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather
         *        it represents how quickly the Snowball moves to its destination while in transit. Regional shipping
         *        speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express
         *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
         *        which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowballs are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
         * represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are
         * as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowballs are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather
         *        it represents how quickly the Snowball moves to its destination while in transit. Regional shipping
         *        speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express
         *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
         *        which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowballs are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * </p>
         * 
         * @param notification
         *        Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * </p>
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().apply(notification).build());
        }

        /**
         * <p>
         * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
         * <code>clusterId</code> value. The other job attributes are inherited from the cluster.
         * </p>
         * 
         * @param clusterId
         *        The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
         *        <code>clusterId</code> value. The other job attributes are inherited from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type
         *        for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type
         *        for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The forwarding address ID for a job. This field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The forwarding address ID for a job. This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String jobType;

        private JobResource resources;

        private String description;

        private String addressId;

        private String kmsKeyARN;

        private String roleARN;

        private String snowballCapacityPreference;

        private String shippingOption;

        private Notification notification;

        private String clusterId;

        private String snowballType;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            jobType(model.jobType);
            resources(model.resources);
            description(model.description);
            addressId(model.addressId);
            kmsKeyARN(model.kmsKeyARN);
            roleARN(model.roleARN);
            snowballCapacityPreference(model.snowballCapacityPreference);
            shippingOption(model.shippingOption);
            notification(model.notification);
            clusterId(model.clusterId);
            snowballType(model.snowballType);
            forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource.Builder getResources() {
            return resources != null ? resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballCapacityPreference() {
            return snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }
    }
}
