/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetJobUnlockCodeRequest extends SnowballRequest implements
        ToCopyableBuilder<GetJobUnlockCodeRequest.Builder, GetJobUnlockCodeRequest> {
    private final String jobId;

    private GetJobUnlockCodeRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
    }

    /**
     * <p>
     * The ID for the job that you want to get the <code>UnlockCode</code> value for, for example
     * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The ID for the job that you want to get the <code>UnlockCode</code> value for, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String jobId() {
        return jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobUnlockCodeRequest)) {
            return false;
        }
        GetJobUnlockCodeRequest other = (GetJobUnlockCodeRequest) obj;
        return Objects.equals(jobId(), other.jobId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetJobUnlockCodeRequest").add("JobId", jobId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.of(clazz.cast(jobId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnowballRequest.Builder, CopyableBuilder<Builder, GetJobUnlockCodeRequest> {
        /**
         * <p>
         * The ID for the job that you want to get the <code>UnlockCode</code> value for, for example
         * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The ID for the job that you want to get the <code>UnlockCode</code> value for, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobUnlockCodeRequest model) {
            super(model);
            jobId(model.jobId);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetJobUnlockCodeRequest build() {
            return new GetJobUnlockCodeRequest(this);
        }
    }
}
