/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.LambdaResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaResource implements StructuredPojo, ToCopyableBuilder<LambdaResource.Builder, LambdaResource> {
    private final String lambdaArn;

    private final List<EventTriggerDefinition> eventTriggers;

    private LambdaResource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.eventTriggers = builder.eventTriggers;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object actions on the
     * associated local Amazon S3 resource.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object
     *         actions on the associated local Amazon S3 resource.
     */
    public String lambdaArn() {
        return lambdaArn;
    }

    /**
     * <p>
     * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with this
     * job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated
     *         with this job.
     */
    public List<EventTriggerDefinition> eventTriggers() {
        return eventTriggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventTriggers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaResource)) {
            return false;
        }
        LambdaResource other = (LambdaResource) obj;
        return Objects.equals(lambdaArn(), other.lambdaArn()) && Objects.equals(eventTriggers(), other.eventTriggers());
    }

    @Override
    public String toString() {
        return ToString.builder("LambdaResource").add("LambdaArn", lambdaArn()).add("EventTriggers", eventTriggers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaArn":
            return Optional.of(clazz.cast(lambdaArn()));
        case "EventTriggers":
            return Optional.of(clazz.cast(eventTriggers()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object actions on
         * the associated local Amazon S3 resource.
         * </p>
         * 
         * @param lambdaArn
         *        An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object
         *        actions on the associated local Amazon S3 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(EventTriggerDefinition... eventTriggers);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventTriggerDefinition>.Builder} avoiding
         * the need to create one manually via {@link List<EventTriggerDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventTriggerDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #eventTriggers(List<EventTriggerDefinition>)}.
         * 
         * @param eventTriggers
         *        a consumer that will call methods on {@link List<EventTriggerDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTriggers(List<EventTriggerDefinition>)
         */
        Builder eventTriggers(Consumer<EventTriggerDefinition.Builder>... eventTriggers);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaArn;

        private List<EventTriggerDefinition> eventTriggers;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaResource model) {
            lambdaArn(model.lambdaArn);
            eventTriggers(model.eventTriggers);
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        public final Collection<EventTriggerDefinition.Builder> getEventTriggers() {
            return eventTriggers != null ? eventTriggers.stream().map(EventTriggerDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(EventTriggerDefinition... eventTriggers) {
            eventTriggers(Arrays.asList(eventTriggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(Consumer<EventTriggerDefinition.Builder>... eventTriggers) {
            eventTriggers(Stream.of(eventTriggers).map(c -> EventTriggerDefinition.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventTriggers(Collection<EventTriggerDefinition.BuilderImpl> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copyFromBuilder(eventTriggers);
        }

        @Override
        public LambdaResource build() {
            return new LambdaResource(this);
        }
    }
}
