/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListClusterJobsResponse extends SnowballResponse implements
        ToCopyableBuilder<ListClusterJobsResponse.Builder, ListClusterJobsResponse> {
    private final List<JobListEntry> jobListEntries;

    private final String nextToken;

    private ListClusterJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobListEntries = builder.jobListEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the
     * job is a job part, in the case of export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
     *         whether the job is a job part, in the case of export jobs.
     */
    public List<JobListEntry> jobListEntries() {
        return jobListEntries;
    }

    /**
     * <p>
     * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
     * <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.
     * </p>
     * 
     * @return HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your
     *         next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in
     *         the array.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobListEntries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterJobsResponse)) {
            return false;
        }
        ListClusterJobsResponse other = (ListClusterJobsResponse) obj;
        return Objects.equals(jobListEntries(), other.jobListEntries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListClusterJobsResponse").add("JobListEntries", jobListEntries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobListEntries":
            return Optional.of(clazz.cast(jobListEntries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnowballResponse.Builder, CopyableBuilder<Builder, ListClusterJobsResponse> {
        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * 
         * @param jobListEntries
         *        Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
         *        whether the job is a job part, in the case of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(Collection<JobListEntry> jobListEntries);

        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * 
         * @param jobListEntries
         *        Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
         *        whether the job is a job part, in the case of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(JobListEntry... jobListEntries);

        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobListEntry>.Builder} avoiding the need to
         * create one manually via {@link List<JobListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobListEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobListEntries(List<JobListEntry>)}.
         * 
         * @param jobListEntries
         *        a consumer that will call methods on {@link List<JobListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobListEntries(List<JobListEntry>)
         */
        Builder jobListEntries(Consumer<JobListEntry.Builder>... jobListEntries);

        /**
         * <p>
         * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
         * <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.
         * </p>
         * 
         * @param nextToken
         *        HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in
         *        your next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this
         *        point in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<JobListEntry> jobListEntries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterJobsResponse model) {
            super(model);
            jobListEntries(model.jobListEntries);
            nextToken(model.nextToken);
        }

        public final Collection<JobListEntry.Builder> getJobListEntries() {
            return jobListEntries != null ? jobListEntries.stream().map(JobListEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder jobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(JobListEntry... jobListEntries) {
            jobListEntries(Arrays.asList(jobListEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(Consumer<JobListEntry.Builder>... jobListEntries) {
            jobListEntries(Stream.of(jobListEntries).map(c -> JobListEntry.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setJobListEntries(Collection<JobListEntry.BuilderImpl> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copyFromBuilder(jobListEntries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClusterJobsResponse build() {
            return new ListClusterJobsResponse(this);
        }
    }
}
