/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.JobMetadata;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link JobMetadata} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class JobMetadataMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();

    private static final MarshallingInfo<String> JOBSTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobState").isBinary(false).build();

    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").isBinary(false).build();

    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyARN").isBinary(false).build();

    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();

    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SHIPPINGDETAILS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ShippingDetails").isBinary(false).build();

    private static final MarshallingInfo<String> SNOWBALLCAPACITYPREFERENCE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SnowballCapacityPreference").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DATATRANSFERPROGRESS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DataTransferProgress").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> JOBLOGINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobLogInfo").isBinary(false).build();

    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();

    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").isBinary(false).build();

    private static final JobMetadataMarshaller INSTANCE = new JobMetadataMarshaller();

    private JobMetadataMarshaller() {
    }

    public static JobMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(JobMetadata jobMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(jobMetadata, "jobMetadata");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(jobMetadata.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall(jobMetadata.jobStateAsString(), JOBSTATE_BINDING);
            protocolMarshaller.marshall(jobMetadata.jobTypeAsString(), JOBTYPE_BINDING);
            protocolMarshaller.marshall(jobMetadata.snowballTypeAsString(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall(jobMetadata.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(jobMetadata.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall(jobMetadata.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(jobMetadata.kmsKeyARN(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall(jobMetadata.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(jobMetadata.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall(jobMetadata.shippingDetails(), SHIPPINGDETAILS_BINDING);
            protocolMarshaller.marshall(jobMetadata.snowballCapacityPreferenceAsString(), SNOWBALLCAPACITYPREFERENCE_BINDING);
            protocolMarshaller.marshall(jobMetadata.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall(jobMetadata.dataTransferProgress(), DATATRANSFERPROGRESS_BINDING);
            protocolMarshaller.marshall(jobMetadata.jobLogInfo(), JOBLOGINFO_BINDING);
            protocolMarshaller.marshall(jobMetadata.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall(jobMetadata.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
