/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateJobRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLCAPACITYPREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballCapacityPreference").isBinary(false).build();
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").isBinary(false).build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").isBinary(false).build();
    private static final CreateJobRequestModelMarshaller INSTANCE = new CreateJobRequestModelMarshaller();

    private CreateJobRequestModelMarshaller() {
    }

    public static CreateJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateJobRequest createJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createJobRequest), (String)"createJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createJobRequest.jobTypeAsString(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.kmsKeyARN(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.snowballCapacityPreferenceAsString(), SNOWBALLCAPACITYPREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.shippingOptionAsString(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.snowballTypeAsString(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

