/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.JobListEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobListEntryMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobState").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISMASTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsMaster").isBinary(false).build();
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final JobListEntryMarshaller INSTANCE = new JobListEntryMarshaller();

    private JobListEntryMarshaller() {
    }

    public static JobListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobListEntry jobListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobListEntry, (String)"jobListEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobListEntry.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.jobStateAsString(), JOBSTATE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.isMaster(), ISMASTER_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.jobTypeAsString(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.snowballTypeAsString(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

