/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.JobMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobMetadataMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobState").isBinary(false).build();
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SHIPPINGDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingDetails").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLCAPACITYPREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballCapacityPreference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DATATRANSFERPROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTransferProgress").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> JOBLOGINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobLogInfo").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").isBinary(false).build();
    private static final JobMetadataMarshaller INSTANCE = new JobMetadataMarshaller();

    private JobMetadataMarshaller() {
    }

    public static JobMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobMetadata jobMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobMetadata, (String)"jobMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobMetadata.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.jobStateAsString(), JOBSTATE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.jobTypeAsString(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.snowballTypeAsString(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.kmsKeyARN(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.shippingDetails(), SHIPPINGDETAILS_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.snowballCapacityPreferenceAsString(), SNOWBALLCAPACITYPREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.dataTransferProgress(), DATATRANSFERPROGRESS_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.jobLogInfo(), JOBLOGINFO_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

