/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.ClusterState;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.services.snowball.transform.ClusterMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ClusterMetadata> {
    private final String clusterId;
    private final String description;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String clusterState;
    private final String jobType;
    private final String snowballType;
    private final Instant creationDate;
    private final JobResource resources;
    private final String addressId;
    private final String shippingOption;
    private final Notification notification;
    private final String forwardingAddressId;

    private ClusterMetadata(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.description = builder.description;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.clusterState = builder.clusterState;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.resources = builder.resources;
        this.addressId = builder.addressId;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String description() {
        return this.description;
    }

    public String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public ClusterState clusterState() {
        return ClusterState.fromValue(this.clusterState);
    }

    public String clusterStateAsString() {
        return this.clusterState;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeAsString() {
        return this.jobType;
    }

    public SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public String snowballTypeAsString() {
        return this.snowballType;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String addressId() {
        return this.addressId;
    }

    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public String shippingOptionAsString() {
        return this.shippingOption;
    }

    public Notification notification() {
        return this.notification;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingAddressId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterMetadata)) {
            return false;
        }
        ClusterMetadata other = (ClusterMetadata)obj;
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.clusterStateAsString(), other.clusterStateAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.shippingOptionAsString(), other.shippingOptionAsString()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.forwardingAddressId(), other.forwardingAddressId());
    }

    public String toString() {
        return ToString.builder((String)"ClusterMetadata").add("ClusterId", (Object)this.clusterId()).add("Description", (Object)this.description()).add("KmsKeyARN", (Object)this.kmsKeyARN()).add("RoleARN", (Object)this.roleARN()).add("ClusterState", (Object)this.clusterStateAsString()).add("JobType", (Object)this.jobTypeAsString()).add("SnowballType", (Object)this.snowballTypeAsString()).add("CreationDate", (Object)this.creationDate()).add("Resources", (Object)this.resources()).add("AddressId", (Object)this.addressId()).add("ShippingOption", (Object)this.shippingOptionAsString()).add("Notification", (Object)this.notification()).add("ForwardingAddressId", (Object)this.forwardingAddressId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KmsKeyARN": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ClusterState": {
                return Optional.ofNullable(clazz.cast(this.clusterStateAsString()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "AddressId": {
                return Optional.ofNullable(clazz.cast(this.addressId()));
            }
            case "ShippingOption": {
                return Optional.ofNullable(clazz.cast(this.shippingOptionAsString()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "ForwardingAddressId": {
                return Optional.ofNullable(clazz.cast(this.forwardingAddressId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String description;
        private String kmsKeyARN;
        private String roleARN;
        private String clusterState;
        private String jobType;
        private String snowballType;
        private Instant creationDate;
        private JobResource resources;
        private String addressId;
        private String shippingOption;
        private Notification notification;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterMetadata model) {
            this.clusterId(model.clusterId);
            this.description(model.description);
            this.kmsKeyARN(model.kmsKeyARN);
            this.roleARN(model.roleARN);
            this.clusterState(model.clusterState);
            this.jobType(model.jobType);
            this.snowballType(model.snowballType);
            this.creationDate(model.creationDate);
            this.resources(model.resources);
            this.addressId(model.addressId);
            this.shippingOption(model.shippingOption);
            this.notification(model.notification);
            this.forwardingAddressId(model.forwardingAddressId);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterState() {
            return this.clusterState;
        }

        @Override
        public final Builder clusterState(String clusterState) {
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public final Builder clusterState(ClusterState clusterState) {
            this.clusterState(clusterState.toString());
            return this;
        }

        public final void setClusterState(String clusterState) {
            this.clusterState = clusterState;
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        public ClusterMetadata build() {
            return new ClusterMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterMetadata> {
        public Builder clusterId(String var1);

        public Builder description(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder clusterState(String var1);

        public Builder clusterState(ClusterState var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder creationDate(Instant var1);

        public Builder resources(JobResource var1);

        default public Builder resources(Consumer<JobResource.Builder> resources) {
            return this.resources((JobResource)((JobResource.Builder)JobResource.builder().applyMutation(resources)).build());
        }

        public Builder addressId(String var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder forwardingAddressId(String var1);
    }
}

