/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.LambdaResource;
import software.amazon.awssdk.services.snowball.model.LambdaResourceListCopier;
import software.amazon.awssdk.services.snowball.model.S3Resource;
import software.amazon.awssdk.services.snowball.model.S3ResourceListCopier;
import software.amazon.awssdk.services.snowball.transform.JobResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobResource
implements StructuredPojo,
ToCopyableBuilder<Builder, JobResource> {
    private final List<S3Resource> s3Resources;
    private final List<LambdaResource> lambdaResources;

    private JobResource(BuilderImpl builder) {
        this.s3Resources = builder.s3Resources;
        this.lambdaResources = builder.lambdaResources;
    }

    public List<S3Resource> s3Resources() {
        return this.s3Resources;
    }

    public List<LambdaResource> lambdaResources() {
        return this.lambdaResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaResources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobResource)) {
            return false;
        }
        JobResource other = (JobResource)obj;
        return Objects.equals(this.s3Resources(), other.s3Resources()) && Objects.equals(this.lambdaResources(), other.lambdaResources());
    }

    public String toString() {
        return ToString.builder((String)"JobResource").add("S3Resources", this.s3Resources()).add("LambdaResources", this.lambdaResources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Resources": {
                return Optional.ofNullable(clazz.cast(this.s3Resources()));
            }
            case "LambdaResources": {
                return Optional.ofNullable(clazz.cast(this.lambdaResources()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3Resource> s3Resources = DefaultSdkAutoConstructList.getInstance();
        private List<LambdaResource> lambdaResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobResource model) {
            this.s3Resources(model.s3Resources);
            this.lambdaResources(model.lambdaResources);
        }

        public final Collection<S3Resource.Builder> getS3Resources() {
            return this.s3Resources != null ? (Collection)this.s3Resources.stream().map(S3Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Resources(Collection<S3Resource> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3Resource ... s3Resources) {
            this.s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(Consumer<S3Resource.Builder> ... s3Resources) {
            this.s3Resources(Stream.of(s3Resources).map(c -> (S3Resource)((S3Resource.Builder)S3Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3Resources(Collection<S3Resource.BuilderImpl> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copyFromBuilder(s3Resources);
        }

        public final Collection<LambdaResource.Builder> getLambdaResources() {
            return this.lambdaResources != null ? (Collection)this.lambdaResources.stream().map(LambdaResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lambdaResources(Collection<LambdaResource> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copy(lambdaResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(LambdaResource ... lambdaResources) {
            this.lambdaResources(Arrays.asList(lambdaResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(Consumer<LambdaResource.Builder> ... lambdaResources) {
            this.lambdaResources(Stream.of(lambdaResources).map(c -> (LambdaResource)((LambdaResource.Builder)LambdaResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLambdaResources(Collection<LambdaResource.BuilderImpl> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copyFromBuilder(lambdaResources);
        }

        public JobResource build() {
            return new JobResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobResource> {
        public Builder s3Resources(Collection<S3Resource> var1);

        public Builder s3Resources(S3Resource ... var1);

        public Builder s3Resources(Consumer<S3Resource.Builder> ... var1);

        public Builder lambdaResources(Collection<LambdaResource> var1);

        public Builder lambdaResources(LambdaResource ... var1);

        public Builder lambdaResources(Consumer<LambdaResource.Builder> ... var1);
    }
}

