/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JobState {
    NEW("New"),
    PREPARING_APPLIANCE("PreparingAppliance"),
    PREPARING_SHIPMENT("PreparingShipment"),
    IN_TRANSIT_TO_CUSTOMER("InTransitToCustomer"),
    WITH_CUSTOMER("WithCustomer"),
    IN_TRANSIT_TO_AWS("InTransitToAWS"),
    WITH_AWS("WithAWS"),
    IN_PROGRESS("InProgress"),
    COMPLETE("Complete"),
    CANCELLED("Cancelled"),
    LISTING("Listing"),
    PENDING("Pending"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private JobState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(JobState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobState> knownValues() {
        return Stream.of(JobState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

