/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.JobListEntry;
import software.amazon.awssdk.services.snowball.model.JobListEntryListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterJobsResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, ListClusterJobsResponse> {
    private final List<JobListEntry> jobListEntries;
    private final String nextToken;

    private ListClusterJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobListEntries = builder.jobListEntries;
        this.nextToken = builder.nextToken;
    }

    public List<JobListEntry> jobListEntries() {
        return this.jobListEntries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobListEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterJobsResponse)) {
            return false;
        }
        ListClusterJobsResponse other = (ListClusterJobsResponse)((Object)obj);
        return Objects.equals(this.jobListEntries(), other.jobListEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListClusterJobsResponse").add("JobListEntries", this.jobListEntries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobListEntries": {
                return Optional.ofNullable(clazz.cast(this.jobListEntries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private List<JobListEntry> jobListEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterJobsResponse model) {
            super(model);
            this.jobListEntries(model.jobListEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobListEntry.Builder> getJobListEntries() {
            return this.jobListEntries != null ? (Collection)this.jobListEntries.stream().map(JobListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(JobListEntry ... jobListEntries) {
            this.jobListEntries(Arrays.asList(jobListEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(Consumer<JobListEntry.Builder> ... jobListEntries) {
            this.jobListEntries(Stream.of(jobListEntries).map(c -> (JobListEntry)((JobListEntry.Builder)JobListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobListEntries(Collection<JobListEntry.BuilderImpl> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copyFromBuilder(jobListEntries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClusterJobsResponse build() {
            return new ListClusterJobsResponse(this);
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    CopyableBuilder<Builder, ListClusterJobsResponse> {
        public Builder jobListEntries(Collection<JobListEntry> var1);

        public Builder jobListEntries(JobListEntry ... var1);

        public Builder jobListEntries(Consumer<JobListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

