/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.model.Address;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;

public class DescribeAddressesIterable
implements SdkIterable<DescribeAddressesResponse> {
    private final SnowballClient client;
    private final DescribeAddressesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAddressesIterable(SnowballClient client, DescribeAddressesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAddressesResponseFetcher();
    }

    public Iterator<DescribeAddressesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Address> addresses() {
        Function<DescribeAddressesResponse, Iterator> getIterator = response -> {
            if (response != null && response.addresses() != null) {
                return response.addresses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeAddressesIterable resume(DescribeAddressesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAddressesIterable(this.client, (DescribeAddressesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAddressesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeAddressesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeAddressesResponseFetcher
    implements SyncPageFetcher<DescribeAddressesResponse> {
        private DescribeAddressesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddressesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeAddressesResponse nextPage(DescribeAddressesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddressesIterable.this.client.describeAddresses(DescribeAddressesIterable.this.firstRequest);
            }
            return DescribeAddressesIterable.this.client.describeAddresses((DescribeAddressesRequest)((Object)DescribeAddressesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

