/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.S3Resource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ResourceMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KEYRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyRange").isBinary(false).build();
    private static final S3ResourceMarshaller INSTANCE = new S3ResourceMarshaller();

    private S3ResourceMarshaller() {
    }

    public static S3ResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Resource s3Resource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Resource, (String)"s3Resource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Resource.bucketArn(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3Resource.keyRange(), KEYRANGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

