/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.ShippingDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ShippingDetailsMarshaller {
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INBOUNDSHIPMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboundShipment").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTBOUNDSHIPMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutboundShipment").isBinary(false).build();
    private static final ShippingDetailsMarshaller INSTANCE = new ShippingDetailsMarshaller();

    private ShippingDetailsMarshaller() {
    }

    public static ShippingDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ShippingDetails shippingDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)shippingDetails, (String)"shippingDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)shippingDetails.shippingOptionAsString(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)shippingDetails.inboundShipment(), INBOUNDSHIPMENT_BINDING);
            protocolMarshaller.marshall((Object)shippingDetails.outboundShipment(), OUTBOUNDSHIPMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

