/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.EventTriggerDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for the <a>EventTriggerDefinition$EventResourceARN</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTriggerDefinition implements StructuredPojo,
        ToCopyableBuilder<EventTriggerDefinition.Builder, EventTriggerDefinition> {
    private final String eventResourceARN;

    private EventTriggerDefinition(BuilderImpl builder) {
        this.eventResourceARN = builder.eventResourceARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an AWS Lambda function's event trigger
     * associated with this job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an AWS Lambda function's event
     *         trigger associated with this job.
     */
    public String eventResourceARN() {
        return eventResourceARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventResourceARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTriggerDefinition)) {
            return false;
        }
        EventTriggerDefinition other = (EventTriggerDefinition) obj;
        return Objects.equals(eventResourceARN(), other.eventResourceARN());
    }

    @Override
    public String toString() {
        return ToString.builder("EventTriggerDefinition").add("EventResourceARN", eventResourceARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventResourceARN":
            return Optional.ofNullable(clazz.cast(eventResourceARN()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventTriggerDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EventTriggerDefinition> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an AWS Lambda function's event
         * trigger associated with this job.
         * </p>
         * 
         * @param eventResourceARN
         *        The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an AWS Lambda function's event
         *        trigger associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventResourceARN(String eventResourceARN);
    }

    static final class BuilderImpl implements Builder {
        private String eventResourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTriggerDefinition model) {
            eventResourceARN(model.eventResourceARN);
        }

        public final String getEventResourceARN() {
            return eventResourceARN;
        }

        @Override
        public final Builder eventResourceARN(String eventResourceARN) {
            this.eventResourceARN = eventResourceARN;
            return this;
        }

        public final void setEventResourceARN(String eventResourceARN) {
            this.eventResourceARN = eventResourceARN;
        }

        @Override
        public EventTriggerDefinition build() {
            return new EventTriggerDefinition(this);
        }
    }
}
