/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSnowballUsageResponse extends SnowballResponse implements
        ToCopyableBuilder<GetSnowballUsageResponse.Builder, GetSnowballUsageResponse> {
    private final Integer snowballLimit;

    private final Integer snowballsInUse;

    private GetSnowballUsageResponse(BuilderImpl builder) {
        super(builder);
        this.snowballLimit = builder.snowballLimit;
        this.snowballsInUse = builder.snowballsInUse;
    }

    /**
     * <p>
     * The service limit for number of Snowballs this account can have at once. The default service limit is 1 (one).
     * </p>
     * 
     * @return The service limit for number of Snowballs this account can have at once. The default service limit is 1
     *         (one).
     */
    public Integer snowballLimit() {
        return snowballLimit;
    }

    /**
     * <p>
     * The number of Snowballs that this account is currently using.
     * </p>
     * 
     * @return The number of Snowballs that this account is currently using.
     */
    public Integer snowballsInUse() {
        return snowballsInUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snowballLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snowballsInUse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnowballUsageResponse)) {
            return false;
        }
        GetSnowballUsageResponse other = (GetSnowballUsageResponse) obj;
        return Objects.equals(snowballLimit(), other.snowballLimit()) && Objects.equals(snowballsInUse(), other.snowballsInUse());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSnowballUsageResponse").add("SnowballLimit", snowballLimit())
                .add("SnowballsInUse", snowballsInUse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnowballLimit":
            return Optional.ofNullable(clazz.cast(snowballLimit()));
        case "SnowballsInUse":
            return Optional.ofNullable(clazz.cast(snowballsInUse()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnowballResponse.Builder, CopyableBuilder<Builder, GetSnowballUsageResponse> {
        /**
         * <p>
         * The service limit for number of Snowballs this account can have at once. The default service limit is 1
         * (one).
         * </p>
         * 
         * @param snowballLimit
         *        The service limit for number of Snowballs this account can have at once. The default service limit is
         *        1 (one).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowballLimit(Integer snowballLimit);

        /**
         * <p>
         * The number of Snowballs that this account is currently using.
         * </p>
         * 
         * @param snowballsInUse
         *        The number of Snowballs that this account is currently using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowballsInUse(Integer snowballsInUse);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private Integer snowballLimit;

        private Integer snowballsInUse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnowballUsageResponse model) {
            super(model);
            snowballLimit(model.snowballLimit);
            snowballsInUse(model.snowballsInUse);
        }

        public final Integer getSnowballLimit() {
            return snowballLimit;
        }

        @Override
        public final Builder snowballLimit(Integer snowballLimit) {
            this.snowballLimit = snowballLimit;
            return this;
        }

        public final void setSnowballLimit(Integer snowballLimit) {
            this.snowballLimit = snowballLimit;
        }

        public final Integer getSnowballsInUse() {
            return snowballsInUse;
        }

        @Override
        public final Builder snowballsInUse(Integer snowballsInUse) {
            this.snowballsInUse = snowballsInUse;
            return this;
        }

        public final void setSnowballsInUse(Integer snowballsInUse) {
            this.snowballsInUse = snowballsInUse;
        }

        @Override
        public GetSnowballUsageResponse build() {
            return new GetSnowballUsageResponse(this);
        }
    }
}
