/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.CompatibleImageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompatibleImage
implements StructuredPojo,
ToCopyableBuilder<Builder, CompatibleImage> {
    private final String amiId;
    private final String name;

    private CompatibleImage(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.name = builder.name;
    }

    public String amiId() {
        return this.amiId;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleImage)) {
            return false;
        }
        CompatibleImage other = (CompatibleImage)obj;
        return Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CompatibleImage").add("AmiId", (Object)this.amiId()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompatibleImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String amiId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleImage model) {
            this.amiId(model.amiId);
            this.name(model.name);
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public CompatibleImage build() {
            return new CompatibleImage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompatibleImage> {
        public Builder amiId(String var1);

        public Builder name(String var1);
    }
}

