/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.Ec2AmiResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2AmiResource
implements StructuredPojo,
ToCopyableBuilder<Builder, Ec2AmiResource> {
    private final String amiId;
    private final String snowballAmiId;

    private Ec2AmiResource(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.snowballAmiId = builder.snowballAmiId;
    }

    public String amiId() {
        return this.amiId;
    }

    public String snowballAmiId() {
        return this.snowballAmiId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballAmiId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AmiResource)) {
            return false;
        }
        Ec2AmiResource other = (Ec2AmiResource)obj;
        return Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.snowballAmiId(), other.snowballAmiId());
    }

    public String toString() {
        return ToString.builder((String)"Ec2AmiResource").add("AmiId", (Object)this.amiId()).add("SnowballAmiId", (Object)this.snowballAmiId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "SnowballAmiId": {
                return Optional.ofNullable(clazz.cast(this.snowballAmiId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Ec2AmiResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String amiId;
        private String snowballAmiId;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AmiResource model) {
            this.amiId(model.amiId);
            this.snowballAmiId(model.snowballAmiId);
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSnowballAmiId() {
            return this.snowballAmiId;
        }

        @Override
        public final Builder snowballAmiId(String snowballAmiId) {
            this.snowballAmiId = snowballAmiId;
            return this;
        }

        public final void setSnowballAmiId(String snowballAmiId) {
            this.snowballAmiId = snowballAmiId;
        }

        public Ec2AmiResource build() {
            return new Ec2AmiResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Ec2AmiResource> {
        public Builder amiId(String var1);

        public Builder snowballAmiId(String var1);
    }
}

