/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.EventTriggerDefinition;
import software.amazon.awssdk.services.snowball.model.EventTriggerDefinitionListCopier;
import software.amazon.awssdk.services.snowball.transform.LambdaResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaResource
implements StructuredPojo,
ToCopyableBuilder<Builder, LambdaResource> {
    private final String lambdaArn;
    private final List<EventTriggerDefinition> eventTriggers;

    private LambdaResource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.eventTriggers = builder.eventTriggers;
    }

    public String lambdaArn() {
        return this.lambdaArn;
    }

    public List<EventTriggerDefinition> eventTriggers() {
        return this.eventTriggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTriggers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaResource)) {
            return false;
        }
        LambdaResource other = (LambdaResource)obj;
        return Objects.equals(this.lambdaArn(), other.lambdaArn()) && Objects.equals(this.eventTriggers(), other.eventTriggers());
    }

    public String toString() {
        return ToString.builder((String)"LambdaResource").add("LambdaArn", (Object)this.lambdaArn()).add("EventTriggers", this.eventTriggers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaArn()));
            }
            case "EventTriggers": {
                return Optional.ofNullable(clazz.cast(this.eventTriggers()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaArn;
        private List<EventTriggerDefinition> eventTriggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaResource model) {
            this.lambdaArn(model.lambdaArn);
            this.eventTriggers(model.eventTriggers);
        }

        public final String getLambdaArn() {
            return this.lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        public final Collection<EventTriggerDefinition.Builder> getEventTriggers() {
            return this.eventTriggers != null ? (Collection)this.eventTriggers.stream().map(EventTriggerDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(EventTriggerDefinition ... eventTriggers) {
            this.eventTriggers(Arrays.asList(eventTriggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(Consumer<EventTriggerDefinition.Builder> ... eventTriggers) {
            this.eventTriggers(Stream.of(eventTriggers).map(c -> (EventTriggerDefinition)((EventTriggerDefinition.Builder)EventTriggerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventTriggers(Collection<EventTriggerDefinition.BuilderImpl> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copyFromBuilder(eventTriggers);
        }

        public LambdaResource build() {
            return new LambdaResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LambdaResource> {
        public Builder lambdaArn(String var1);

        public Builder eventTriggers(Collection<EventTriggerDefinition> var1);

        public Builder eventTriggers(EventTriggerDefinition ... var1);

        public Builder eventTriggers(Consumer<EventTriggerDefinition.Builder> ... var1);
    }
}

