/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.DataTransfer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DataTransferMarshaller {
    private static final MarshallingInfo<Long> BYTESTRANSFERRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesTransferred").isBinary(false).build();
    private static final MarshallingInfo<Long> OBJECTSTRANSFERRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectsTransferred").isBinary(false).build();
    private static final MarshallingInfo<Long> TOTALBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalBytes").isBinary(false).build();
    private static final MarshallingInfo<Long> TOTALOBJECTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalObjects").isBinary(false).build();
    private static final DataTransferMarshaller INSTANCE = new DataTransferMarshaller();

    private DataTransferMarshaller() {
    }

    public static DataTransferMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DataTransfer dataTransfer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dataTransfer, (String)"dataTransfer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dataTransfer.bytesTransferred(), BYTESTRANSFERRED_BINDING);
            protocolMarshaller.marshall((Object)dataTransfer.objectsTransferred(), OBJECTSTRANSFERRED_BINDING);
            protocolMarshaller.marshall((Object)dataTransfer.totalBytes(), TOTALBYTES_BINDING);
            protocolMarshaller.marshall((Object)dataTransfer.totalObjects(), TOTALOBJECTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

