/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobResourceMarshaller {
    private static final MarshallingInfo<List> S3RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Resources").isBinary(false).build();
    private static final MarshallingInfo<List> LAMBDARESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaResources").isBinary(false).build();
    private static final MarshallingInfo<List> EC2AMIRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2AmiResources").isBinary(false).build();
    private static final JobResourceMarshaller INSTANCE = new JobResourceMarshaller();

    private JobResourceMarshaller() {
    }

    public static JobResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobResource jobResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobResource, (String)"jobResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(jobResource.s3Resources(), S3RESOURCES_BINDING);
            protocolMarshaller.marshall(jobResource.lambdaResources(), LAMBDARESOURCES_BINDING);
            protocolMarshaller.marshall(jobResource.ec2AmiResources(), EC2AMIRESOURCES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

