/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.ClusterMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a specific cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ClusterMetadata implements StructuredPojo, ToCopyableBuilder<ClusterMetadata.Builder, ClusterMetadata> {
    private final String clusterId;

    private final String description;

    private final String kmsKeyARN;

    private final String roleARN;

    private final String clusterState;

    private final String jobType;

    private final String snowballType;

    private final Instant creationDate;

    private final JobResource resources;

    private final String addressId;

    private final String shippingOption;

    private final Notification notification;

    private final String forwardingAddressId;

    private ClusterMetadata(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.description = builder.description;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.clusterState = builder.clusterState;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.resources = builder.resources;
        this.addressId = builder.addressId;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * The automatically generated ID for a cluster.
     * </p>
     * 
     * @return The automatically generated ID for a cluster.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The optional description of the cluster.
     * </p>
     * 
     * @return The optional description of the cluster.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created using
     * the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in
     * AWS Key Management Service (AWS KMS).
     * </p>
     * 
     * @return The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created
     *         using the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a>
     *         API action in AWS Key Management Service (AWS KMS).
     */
    public String kmsKeyARN() {
        return kmsKeyARN;
    }

    /**
     * <p>
     * The role ARN associated with this cluster. This ARN was created using the <a
     * href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in AWS
     * Identity and Access Management (IAM).
     * </p>
     * 
     * @return The role ARN associated with this cluster. This ARN was created using the <a
     *         href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *         in AWS Identity and Access Management (IAM).
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The current status of the cluster.
     * </p>
     * 
     * @return The current status of the cluster.
     * @see ClusterState
     */
    public String clusterState() {
        return clusterState;
    }

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * 
     * @return The type of job for this cluster. Currently, the only job type supported for clusters is
     *         <code>LOCAL_USE</code>.
     * @see JobType
     */
    public String jobType() {
        return jobType;
    }

    /**
     * <p>
     * The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type for
     * cluster jobs is <code>EDGE</code>.
     * </p>
     * 
     * @return The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type
     *         for cluster jobs is <code>EDGE</code>.
     * @see SnowballType
     */
    public String snowballType() {
        return snowballType;
    }

    /**
     * <p>
     * The creation date for this cluster.
     * </p>
     * 
     * @return The creation date for this cluster.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
     * <a>LambdaResource</a> objects.
     * </p>
     * 
     * @return The arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
     *         <a>LambdaResource</a> objects.
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * The automatically generated ID for a specific address.
     * </p>
     * 
     * @return The automatically generated ID for a specific address.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge appliance, rather it represents how quickly each appliance moves to its destination while in transit.
     * Regional shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snowball Edges are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
     *         Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination while
     *         in transit. Regional shipping speeds are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in
     *         about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped
     *         express are delivered in about a day. In addition, most countries in the EU have access to standard
     *         shipping, which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snowball Edges are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public String shippingOption() {
        return shippingOption;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This
     * field is not supported in most regions.
     * </p>
     * 
     * @return The ID of the address that you want a cluster shipped to, after it will be shipped to its primary
     *         address. This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clusterId() == null) ? 0 : clusterId().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((kmsKeyARN() == null) ? 0 : kmsKeyARN().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((clusterState() == null) ? 0 : clusterState().hashCode());
        hashCode = 31 * hashCode + ((jobType() == null) ? 0 : jobType().hashCode());
        hashCode = 31 * hashCode + ((snowballType() == null) ? 0 : snowballType().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((resources() == null) ? 0 : resources().hashCode());
        hashCode = 31 * hashCode + ((addressId() == null) ? 0 : addressId().hashCode());
        hashCode = 31 * hashCode + ((shippingOption() == null) ? 0 : shippingOption().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((forwardingAddressId() == null) ? 0 : forwardingAddressId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterMetadata)) {
            return false;
        }
        ClusterMetadata other = (ClusterMetadata) obj;
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.kmsKeyARN() == null ^ this.kmsKeyARN() == null) {
            return false;
        }
        if (other.kmsKeyARN() != null && !other.kmsKeyARN().equals(this.kmsKeyARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.clusterState() == null ^ this.clusterState() == null) {
            return false;
        }
        if (other.clusterState() != null && !other.clusterState().equals(this.clusterState())) {
            return false;
        }
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.shippingOption() == null ^ this.shippingOption() == null) {
            return false;
        }
        if (other.shippingOption() != null && !other.shippingOption().equals(this.shippingOption())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        if (other.forwardingAddressId() != null && !other.forwardingAddressId().equals(this.forwardingAddressId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (clusterId() != null) {
            sb.append("ClusterId: ").append(clusterId()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(kmsKeyARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (clusterState() != null) {
            sb.append("ClusterState: ").append(clusterState()).append(",");
        }
        if (jobType() != null) {
            sb.append("JobType: ").append(jobType()).append(",");
        }
        if (snowballType() != null) {
            sb.append("SnowballType: ").append(snowballType()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (resources() != null) {
            sb.append("Resources: ").append(resources()).append(",");
        }
        if (addressId() != null) {
            sb.append("AddressId: ").append(addressId()).append(",");
        }
        if (shippingOption() != null) {
            sb.append("ShippingOption: ").append(shippingOption()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(forwardingAddressId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ClusterMetadata> {
        /**
         * <p>
         * The automatically generated ID for a cluster.
         * </p>
         * 
         * @param clusterId
         *        The automatically generated ID for a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The optional description of the cluster.
         * </p>
         * 
         * @param description
         *        The optional description of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created
         * using the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API
         * action in AWS Key Management Service (AWS KMS).
         * </p>
         * 
         * @param kmsKeyARN
         *        The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was
         *        created using the <a
         *        href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action
         *        in AWS Key Management Service (AWS KMS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyARN(String kmsKeyARN);

        /**
         * <p>
         * The role ARN associated with this cluster. This ARN was created using the <a
         * href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in
         * AWS Identity and Access Management (IAM).
         * </p>
         * 
         * @param roleARN
         *        The role ARN associated with this cluster. This ARN was created using the <a
         *        href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
         *        action in AWS Identity and Access Management (IAM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The current status of the cluster.
         * </p>
         * 
         * @param clusterState
         *        The current status of the cluster.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder clusterState(String clusterState);

        /**
         * <p>
         * The current status of the cluster.
         * </p>
         * 
         * @param clusterState
         *        The current status of the cluster.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder clusterState(ClusterState clusterState);

        /**
         * <p>
         * The type of job for this cluster. Currently, the only job type supported for clusters is
         * <code>LOCAL_USE</code>.
         * </p>
         * 
         * @param jobType
         *        The type of job for this cluster. Currently, the only job type supported for clusters is
         *        <code>LOCAL_USE</code>.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of job for this cluster. Currently, the only job type supported for clusters is
         * <code>LOCAL_USE</code>.
         * </p>
         * 
         * @param jobType
         *        The type of job for this cluster. Currently, the only job type supported for clusters is
         *        <code>LOCAL_USE</code>.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance
         *        type for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance
         *        type for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The creation date for this cluster.
         * </p>
         * 
         * @param creationDate
         *        The creation date for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
         * <a>LambdaResource</a> objects.
         * </p>
         * 
         * @param resources
         *        The arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
         *        <a>LambdaResource</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * The automatically generated ID for a specific address.
         * </p>
         * 
         * @param addressId
         *        The automatically generated ID for a specific address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         * Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination while in
         * transit. Regional shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express
         * are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowball Edges are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         *        Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination
         *        while in transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, appliances shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowball Edges are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         * Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination while in
         * transit. Regional shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express
         * are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowball Edges are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         *        Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination
         *        while in transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, appliances shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowball Edges are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
         * </p>
         * 
         * @param notification
         *        The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address.
         * This field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The ID of the address that you want a cluster shipped to, after it will be shipped to its primary
         *        address. This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);
    }

    private static final class BuilderImpl implements Builder {
        private String clusterId;

        private String description;

        private String kmsKeyARN;

        private String roleARN;

        private String clusterState;

        private String jobType;

        private String snowballType;

        private Instant creationDate;

        private JobResource resources;

        private String addressId;

        private String shippingOption;

        private Notification notification;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterMetadata model) {
            setClusterId(model.clusterId);
            setDescription(model.description);
            setKmsKeyARN(model.kmsKeyARN);
            setRoleARN(model.roleARN);
            setClusterState(model.clusterState);
            setJobType(model.jobType);
            setSnowballType(model.snowballType);
            setCreationDate(model.creationDate);
            setResources(model.resources);
            setAddressId(model.addressId);
            setShippingOption(model.shippingOption);
            setNotification(model.notification);
            setForwardingAddressId(model.forwardingAddressId);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyARN() {
            return kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterState() {
            return clusterState;
        }

        @Override
        public final Builder clusterState(String clusterState) {
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public final Builder clusterState(ClusterState clusterState) {
            this.clusterState(clusterState.toString());
            return this;
        }

        public final void setClusterState(String clusterState) {
            this.clusterState = clusterState;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final JobResource getResources() {
            return resources;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource resources) {
            this.resources = resources;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification getNotification() {
            return notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public ClusterMetadata build() {
            return new ClusterMetadata(this);
        }
    }
}
