/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateClusterRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private final String jobType;

    private final JobResource resources;

    private final String description;

    private final String addressId;

    private final String kmsKeyARN;

    private final String roleARN;

    private final String snowballType;

    private final String shippingOption;

    private final Notification notification;

    private final String forwardingAddressId;

    private CreateClusterRequest(BuilderImpl builder) {
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballType = builder.snowballType;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * 
     * @return The type of job for this cluster. Currently, the only job type supported for clusters is
     *         <code>LOCAL_USE</code>.
     * @see JobType
     */
    public String jobType() {
        return jobType;
    }

    /**
     * <p>
     * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional AWS Lambda
     * functions written in the Python language.
     * </p>
     * 
     * @return The resources associated with the cluster job. These resources include Amazon S3 buckets and optional AWS
     *         Lambda functions written in the Python language.
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     * </p>
     * 
     * @return An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID for the address that you want the cluster shipped to.&gt;
     * </p>
     * 
     * @return The ID for the address that you want the cluster shipped to.&gt;
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are
     * created by using the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS Key
     * Management Service (AWS KMS).
     * </p>
     * 
     * @return The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code>
     *         values are created by using the <a
     *         href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in
     *         AWS Key Management Service (AWS KMS).
     */
    public String kmsKeyARN() {
        return kmsKeyARN;
    }

    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by
     * using the <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
     * action in AWS Identity and Access Management (IAM).
     * </p>
     * 
     * @return The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are
     *         created by using the <a
     *         href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *         in AWS Identity and Access Management (IAM).
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type for
     * cluster jobs is <code>EDGE</code>.
     * </p>
     * 
     * @return The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type
     *         for cluster jobs is <code>EDGE</code>.
     * @see SnowballType
     */
    public String snowballType() {
        return snowballType;
    }

    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge appliance, rather it represents how quickly each appliance moves to its destination while in transit.
     * Regional shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snowball Edges are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
     *         Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination while
     *         in transit. Regional shipping speeds are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in
     *         about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped
     *         express are delivered in about a day. In addition, most countries in the EU have access to standard
     *         shipping, which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snowball Edges are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public String shippingOption() {
        return shippingOption;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The forwarding address ID for a cluster. This field is not supported in most regions.
     * </p>
     * 
     * @return The forwarding address ID for a cluster. This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobType() == null) ? 0 : jobType().hashCode());
        hashCode = 31 * hashCode + ((resources() == null) ? 0 : resources().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((addressId() == null) ? 0 : addressId().hashCode());
        hashCode = 31 * hashCode + ((kmsKeyARN() == null) ? 0 : kmsKeyARN().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((snowballType() == null) ? 0 : snowballType().hashCode());
        hashCode = 31 * hashCode + ((shippingOption() == null) ? 0 : shippingOption().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((forwardingAddressId() == null) ? 0 : forwardingAddressId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.kmsKeyARN() == null ^ this.kmsKeyARN() == null) {
            return false;
        }
        if (other.kmsKeyARN() != null && !other.kmsKeyARN().equals(this.kmsKeyARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.shippingOption() == null ^ this.shippingOption() == null) {
            return false;
        }
        if (other.shippingOption() != null && !other.shippingOption().equals(this.shippingOption())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        if (other.forwardingAddressId() != null && !other.forwardingAddressId().equals(this.forwardingAddressId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobType() != null) {
            sb.append("JobType: ").append(jobType()).append(",");
        }
        if (resources() != null) {
            sb.append("Resources: ").append(resources()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (addressId() != null) {
            sb.append("AddressId: ").append(addressId()).append(",");
        }
        if (kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(kmsKeyARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (snowballType() != null) {
            sb.append("SnowballType: ").append(snowballType()).append(",");
        }
        if (shippingOption() != null) {
            sb.append("ShippingOption: ").append(shippingOption()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(forwardingAddressId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The type of job for this cluster. Currently, the only job type supported for clusters is
         * <code>LOCAL_USE</code>.
         * </p>
         * 
         * @param jobType
         *        The type of job for this cluster. Currently, the only job type supported for clusters is
         *        <code>LOCAL_USE</code>.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of job for this cluster. Currently, the only job type supported for clusters is
         * <code>LOCAL_USE</code>.
         * </p>
         * 
         * @param jobType
         *        The type of job for this cluster. Currently, the only job type supported for clusters is
         *        <code>LOCAL_USE</code>.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional AWS
         * Lambda functions written in the Python language.
         * </p>
         * 
         * @param resources
         *        The resources associated with the cluster job. These resources include Amazon S3 buckets and optional
         *        AWS Lambda functions written in the Python language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
         * </p>
         * 
         * @param description
         *        An optional description of this specific cluster, for example
         *        <code>Environmental Data Cluster-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID for the address that you want the cluster shipped to.&gt;
         * </p>
         * 
         * @param addressId
         *        The ID for the address that you want the cluster shipped to.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values
         * are created by using the <a
         * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS
         * Key Management Service (AWS KMS).
         * </p>
         * 
         * @param kmsKeyARN
         *        The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code>
         *        values are created by using the <a
         *        href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action
         *        in AWS Key Management Service (AWS KMS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyARN(String kmsKeyARN);

        /**
         * <p>
         * The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are
         * created by using the <a
         * href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in
         * AWS Identity and Access Management (IAM).
         * </p>
         * 
         * @param roleARN
         *        The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are
         *        created by using the <a
         *        href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
         *        action in AWS Identity and Access Management (IAM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance
         *        type for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this cluster. Currently, the only supported appliance
         *        type for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         * Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination while in
         * transit. Regional shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express
         * are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowball Edges are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         *        Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination
         *        while in transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, appliances shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowball Edges are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         * Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination while in
         * transit. Regional shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, appliances shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express
         * are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowball Edges are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
         *        Snowball Edge appliance, rather it represents how quickly each appliance moves to its destination
         *        while in transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, appliances shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped
         *        express are delivered in about a day. In addition, most countries in the EU have access to standard
         *        shipping, which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowball Edges are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
         * </p>
         * 
         * @param notification
         *        The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The forwarding address ID for a cluster. This field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The forwarding address ID for a cluster. This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);
    }

    private static final class BuilderImpl implements Builder {
        private String jobType;

        private JobResource resources;

        private String description;

        private String addressId;

        private String kmsKeyARN;

        private String roleARN;

        private String snowballType;

        private String shippingOption;

        private Notification notification;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            setJobType(model.jobType);
            setResources(model.resources);
            setDescription(model.description);
            setAddressId(model.addressId);
            setKmsKeyARN(model.kmsKeyARN);
            setRoleARN(model.roleARN);
            setSnowballType(model.snowballType);
            setShippingOption(model.shippingOption);
            setNotification(model.notification);
            setForwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource getResources() {
            return resources;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource resources) {
            this.resources = resources;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification getNotification() {
            return notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }
    }
}
