/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateJobRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private final String jobType;

    private final JobResource resources;

    private final String description;

    private final String addressId;

    private final String kmsKeyARN;

    private final String roleARN;

    private final String snowballCapacityPreference;

    private final String shippingOption;

    private final Notification notification;

    private final String clusterId;

    private final String snowballType;

    private final String forwardingAddressId;

    private CreateJobRequest(BuilderImpl builder) {
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.clusterId = builder.clusterId;
        this.snowballType = builder.snowballType;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * Defines the type of job that you're creating.
     * </p>
     * 
     * @return Defines the type of job that you're creating.
     * @see JobType
     */
    public String jobType() {
        return jobType;
    }

    /**
     * <p>
     * Defines the Amazon S3 buckets associated with this job.
     * </p>
     * <p>
     * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
     * into.
     * </p>
     * <p>
     * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
     * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define
     * the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
     * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
     * </p>
     * 
     * @return Defines the Amazon S3 buckets associated with this job.</p>
     *         <p>
     *         With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
     *         imported into.
     *         </p>
     *         <p>
     *         With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
     *         exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a
     *         range, you define the length of the range by providing either an inclusive <code>BeginMarker</code>
     *         value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
     * </p>
     * 
     * @return Defines an optional description of this specific job, for example
     *         <code>Important Photos 2016-08-11</code>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID for the address that you want the Snowball shipped to.
     * </p>
     * 
     * @return The ID for the address that you want the Snowball shipped to.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using
     * the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> AWS Key
     * Management Service (KMS) API action.
     * </p>
     * 
     * @return The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created
     *         using the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a>
     *         AWS Key Management Service (KMS) API action.
     */
    public String kmsKeyARN() {
        return kmsKeyARN;
    }

    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a
     * href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> AWS Identity and
     * Access Management (IAM) API action.
     * </p>
     * 
     * @return The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created
     *         using the <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>
     *         AWS Identity and Access Management (IAM) API action.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snowball you'd
     * like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * 
     * @return If your job is being created in one of the US regions, you have the option of specifying what size
     *         Snowball you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * @see SnowballCapacity
     */
    public String snowballCapacityPreference() {
        return snowballCapacityPreference;
    }

    /**
     * <p>
     * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
     * represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snowballs are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
     *         represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds
     *         are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
     *         about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     *         delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
     *         typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snowballs are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public String shippingOption() {
        return shippingOption;
    }

    /**
     * <p>
     * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
     * </p>
     * 
     * @return Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
     * <code>clusterId</code> value. The other job attributes are inherited from the cluster.
     * </p>
     * 
     * @return The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
     *         <code>clusterId</code> value. The other job attributes are inherited from the cluster.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for cluster
     * jobs is <code>EDGE</code>.
     * </p>
     * 
     * @return The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for
     *         cluster jobs is <code>EDGE</code>.
     * @see SnowballType
     */
    public String snowballType() {
        return snowballType;
    }

    /**
     * <p>
     * The forwarding address ID for a job. This field is not supported in most regions.
     * </p>
     * 
     * @return The forwarding address ID for a job. This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobType() == null) ? 0 : jobType().hashCode());
        hashCode = 31 * hashCode + ((resources() == null) ? 0 : resources().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((addressId() == null) ? 0 : addressId().hashCode());
        hashCode = 31 * hashCode + ((kmsKeyARN() == null) ? 0 : kmsKeyARN().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((snowballCapacityPreference() == null) ? 0 : snowballCapacityPreference().hashCode());
        hashCode = 31 * hashCode + ((shippingOption() == null) ? 0 : shippingOption().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((clusterId() == null) ? 0 : clusterId().hashCode());
        hashCode = 31 * hashCode + ((snowballType() == null) ? 0 : snowballType().hashCode());
        hashCode = 31 * hashCode + ((forwardingAddressId() == null) ? 0 : forwardingAddressId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.kmsKeyARN() == null ^ this.kmsKeyARN() == null) {
            return false;
        }
        if (other.kmsKeyARN() != null && !other.kmsKeyARN().equals(this.kmsKeyARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.snowballCapacityPreference() == null ^ this.snowballCapacityPreference() == null) {
            return false;
        }
        if (other.snowballCapacityPreference() != null
                && !other.snowballCapacityPreference().equals(this.snowballCapacityPreference())) {
            return false;
        }
        if (other.shippingOption() == null ^ this.shippingOption() == null) {
            return false;
        }
        if (other.shippingOption() != null && !other.shippingOption().equals(this.shippingOption())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        if (other.forwardingAddressId() != null && !other.forwardingAddressId().equals(this.forwardingAddressId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobType() != null) {
            sb.append("JobType: ").append(jobType()).append(",");
        }
        if (resources() != null) {
            sb.append("Resources: ").append(resources()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (addressId() != null) {
            sb.append("AddressId: ").append(addressId()).append(",");
        }
        if (kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(kmsKeyARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (snowballCapacityPreference() != null) {
            sb.append("SnowballCapacityPreference: ").append(snowballCapacityPreference()).append(",");
        }
        if (shippingOption() != null) {
            sb.append("ShippingOption: ").append(shippingOption()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (clusterId() != null) {
            sb.append("ClusterId: ").append(clusterId()).append(",");
        }
        if (snowballType() != null) {
            sb.append("SnowballType: ").append(snowballType()).append(",");
        }
        if (forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(forwardingAddressId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * Defines the type of job that you're creating.
         * </p>
         * 
         * @param jobType
         *        Defines the type of job that you're creating.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Defines the type of job that you're creating.
         * </p>
         * 
         * @param jobType
         *        Defines the type of job that you're creating.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * Defines the Amazon S3 buckets associated with this job.
         * </p>
         * <p>
         * With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported
         * into.
         * </p>
         * <p>
         * With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported
         * from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you
         * define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive
         * <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * 
         * @param resources
         *        Defines the Amazon S3 buckets associated with this job.</p>
         *        <p>
         *        With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
         *        imported into.
         *        </p>
         *        <p>
         *        With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be
         *        exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export
         *        a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code>
         *        value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
         * </p>
         * 
         * @param description
         *        Defines an optional description of this specific job, for example
         *        <code>Important Photos 2016-08-11</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID for the address that you want the Snowball shipped to.
         * </p>
         * 
         * @param addressId
         *        The ID for the address that you want the Snowball shipped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created
         * using the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> AWS
         * Key Management Service (KMS) API action.
         * </p>
         * 
         * @param kmsKeyARN
         *        The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are
         *        created using the <a
         *        href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> AWS Key
         *        Management Service (KMS) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyARN(String kmsKeyARN);

        /**
         * <p>
         * The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using
         * the <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> AWS
         * Identity and Access Management (IAM) API action.
         * </p>
         * 
         * @param roleARN
         *        The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created
         *        using the <a
         *        href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> AWS
         *        Identity and Access Management (IAM) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * If your job is being created in one of the US regions, you have the option of specifying what size Snowball
         * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        If your job is being created in one of the US regions, you have the option of specifying what size
         *        Snowball you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(String snowballCapacityPreference);

        /**
         * <p>
         * If your job is being created in one of the US regions, you have the option of specifying what size Snowball
         * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        If your job is being created in one of the US regions, you have the option of specifying what size
         *        Snowball you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference);

        /**
         * <p>
         * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
         * represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are
         * as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowballs are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather
         *        it represents how quickly the Snowball moves to its destination while in transit. Regional shipping
         *        speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express
         *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
         *        which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowballs are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather it
         * represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are
         * as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowballs are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the US, you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snowball, rather
         *        it represents how quickly the Snowball moves to its destination while in transit. Regional shipping
         *        speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express
         *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
         *        which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowballs are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the US, you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * </p>
         * 
         * @param notification
         *        Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
         * <code>clusterId</code> value. The other job attributes are inherited from the cluster.
         * </p>
         * 
         * @param clusterId
         *        The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this
         *        <code>clusterId</code> value. The other job attributes are inherited from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type
         *        for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type for
         * cluster jobs is <code>EDGE</code>.
         * </p>
         * 
         * @param snowballType
         *        The type of AWS Snowball appliance to use for this job. Currently, the only supported appliance type
         *        for cluster jobs is <code>EDGE</code>.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The forwarding address ID for a job. This field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The forwarding address ID for a job. This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);
    }

    private static final class BuilderImpl implements Builder {
        private String jobType;

        private JobResource resources;

        private String description;

        private String addressId;

        private String kmsKeyARN;

        private String roleARN;

        private String snowballCapacityPreference;

        private String shippingOption;

        private Notification notification;

        private String clusterId;

        private String snowballType;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            setJobType(model.jobType);
            setResources(model.resources);
            setDescription(model.description);
            setAddressId(model.addressId);
            setKmsKeyARN(model.kmsKeyARN);
            setRoleARN(model.roleARN);
            setSnowballCapacityPreference(model.snowballCapacityPreference);
            setShippingOption(model.shippingOption);
            setNotification(model.notification);
            setClusterId(model.clusterId);
            setSnowballType(model.snowballType);
            setForwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource getResources() {
            return resources;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource resources) {
            this.resources = resources;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballCapacityPreference() {
            return snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification getNotification() {
            return notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }
    }
}
