/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAddressResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAddressResponse.Builder, DescribeAddressResponse> {
    private final Address address;

    private DescribeAddressResponse(BuilderImpl builder) {
        this.address = builder.address;
    }

    /**
     * <p>
     * The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
     * </p>
     * 
     * @return The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
     */
    public Address address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((address() == null) ? 0 : address().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressResponse)) {
            return false;
        }
        DescribeAddressResponse other = (DescribeAddressResponse) obj;
        if (other.address() == null ^ this.address() == null) {
            return false;
        }
        if (other.address() != null && !other.address().equals(this.address())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (address() != null) {
            sb.append("Address: ").append(address()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAddressResponse> {
        /**
         * <p>
         * The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
         * </p>
         * 
         * @param address
         *        The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);
    }

    private static final class BuilderImpl implements Builder {
        private Address address;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressResponse model) {
            setAddress(model.address);
        }

        public final Address getAddress() {
            return address;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final void setAddress(Address address) {
            this.address = address;
        }

        @Override
        public DescribeAddressResponse build() {
            return new DescribeAddressResponse(this);
        }
    }
}
