/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeClusterResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeClusterResponse.Builder, DescribeClusterResponse> {
    private final ClusterMetadata clusterMetadata;

    private DescribeClusterResponse(BuilderImpl builder) {
        this.clusterMetadata = builder.clusterMetadata;
    }

    /**
     * <p>
     * Information about a specific cluster, including shipping information, cluster status, and other important
     * metadata.
     * </p>
     * 
     * @return Information about a specific cluster, including shipping information, cluster status, and other important
     *         metadata.
     */
    public ClusterMetadata clusterMetadata() {
        return clusterMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clusterMetadata() == null) ? 0 : clusterMetadata().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterResponse)) {
            return false;
        }
        DescribeClusterResponse other = (DescribeClusterResponse) obj;
        if (other.clusterMetadata() == null ^ this.clusterMetadata() == null) {
            return false;
        }
        if (other.clusterMetadata() != null && !other.clusterMetadata().equals(this.clusterMetadata())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (clusterMetadata() != null) {
            sb.append("ClusterMetadata: ").append(clusterMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeClusterResponse> {
        /**
         * <p>
         * Information about a specific cluster, including shipping information, cluster status, and other important
         * metadata.
         * </p>
         * 
         * @param clusterMetadata
         *        Information about a specific cluster, including shipping information, cluster status, and other
         *        important metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterMetadata(ClusterMetadata clusterMetadata);
    }

    private static final class BuilderImpl implements Builder {
        private ClusterMetadata clusterMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterResponse model) {
            setClusterMetadata(model.clusterMetadata);
        }

        public final ClusterMetadata getClusterMetadata() {
            return clusterMetadata;
        }

        @Override
        public final Builder clusterMetadata(ClusterMetadata clusterMetadata) {
            this.clusterMetadata = clusterMetadata;
            return this;
        }

        public final void setClusterMetadata(ClusterMetadata clusterMetadata) {
            this.clusterMetadata = clusterMetadata;
        }

        @Override
        public DescribeClusterResponse build() {
            return new DescribeClusterResponse(this);
        }
    }
}
