/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetJobUnlockCodeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetJobUnlockCodeResponse.Builder, GetJobUnlockCodeResponse> {
    private final String unlockCode;

    private GetJobUnlockCodeResponse(BuilderImpl builder) {
        this.unlockCode = builder.unlockCode;
    }

    /**
     * <p>
     * The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be accessed for up
     * to 90 days after the job has been created.
     * </p>
     * 
     * @return The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be
     *         accessed for up to 90 days after the job has been created.
     */
    public String unlockCode() {
        return unlockCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((unlockCode() == null) ? 0 : unlockCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobUnlockCodeResponse)) {
            return false;
        }
        GetJobUnlockCodeResponse other = (GetJobUnlockCodeResponse) obj;
        if (other.unlockCode() == null ^ this.unlockCode() == null) {
            return false;
        }
        if (other.unlockCode() != null && !other.unlockCode().equals(this.unlockCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (unlockCode() != null) {
            sb.append("UnlockCode: ").append(unlockCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetJobUnlockCodeResponse> {
        /**
         * <p>
         * The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be accessed
         * for up to 90 days after the job has been created.
         * </p>
         * 
         * @param unlockCode
         *        The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be
         *        accessed for up to 90 days after the job has been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlockCode(String unlockCode);
    }

    private static final class BuilderImpl implements Builder {
        private String unlockCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobUnlockCodeResponse model) {
            setUnlockCode(model.unlockCode);
        }

        public final String getUnlockCode() {
            return unlockCode;
        }

        @Override
        public final Builder unlockCode(String unlockCode) {
            this.unlockCode = unlockCode;
            return this;
        }

        public final void setUnlockCode(String unlockCode) {
            this.unlockCode = unlockCode;
        }

        @Override
        public GetJobUnlockCodeResponse build() {
            return new GetJobUnlockCodeResponse(this);
        }
    }
}
