/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.JobListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the job
 * is a job part, in the case of an export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobListEntry implements StructuredPojo, ToCopyableBuilder<JobListEntry.Builder, JobListEntry> {
    private final String jobId;

    private final String jobState;

    private final Boolean isMaster;

    private final String jobType;

    private final String snowballType;

    private final Instant creationDate;

    private final String description;

    private JobListEntry(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.isMaster = builder.isMaster;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The automatically generated ID for a job, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current state of this job.
     * </p>
     * 
     * @return The current state of this job.
     * @see JobState
     */
    public String jobState() {
        return jobState;
    }

    /**
     * <p>
     * A value that indicates that this job is a master job. A master job represents a successful request to create an
     * export job. Master jobs aren't associated with any Snowballs. Instead, each master job will have at least one job
     * part, and each job part is associated with a Snowball. It might take some time before the job parts associated
     * with a particular master job are listed, because they are created after the master job is created.
     * </p>
     * 
     * @return A value that indicates that this job is a master job. A master job represents a successful request to
     *         create an export job. Master jobs aren't associated with any Snowballs. Instead, each master job will
     *         have at least one job part, and each job part is associated with a Snowball. It might take some time
     *         before the job parts associated with a particular master job are listed, because they are created after
     *         the master job is created.
     */
    public Boolean isMaster() {
        return isMaster;
    }

    /**
     * <p>
     * The type of job.
     * </p>
     * 
     * @return The type of job.
     * @see JobType
     */
    public String jobType() {
        return jobType;
    }

    /**
     * <p>
     * The type of appliance used with this job.
     * </p>
     * 
     * @return The type of appliance used with this job.
     * @see SnowballType
     */
    public String snowballType() {
        return snowballType;
    }

    /**
     * <p>
     * The creation date for this job.
     * </p>
     * 
     * @return The creation date for this job.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
     * </p>
     * 
     * @return The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobId() == null) ? 0 : jobId().hashCode());
        hashCode = 31 * hashCode + ((jobState() == null) ? 0 : jobState().hashCode());
        hashCode = 31 * hashCode + ((isMaster() == null) ? 0 : isMaster().hashCode());
        hashCode = 31 * hashCode + ((jobType() == null) ? 0 : jobType().hashCode());
        hashCode = 31 * hashCode + ((snowballType() == null) ? 0 : snowballType().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobListEntry)) {
            return false;
        }
        JobListEntry other = (JobListEntry) obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.jobState() == null ^ this.jobState() == null) {
            return false;
        }
        if (other.jobState() != null && !other.jobState().equals(this.jobState())) {
            return false;
        }
        if (other.isMaster() == null ^ this.isMaster() == null) {
            return false;
        }
        if (other.isMaster() != null && !other.isMaster().equals(this.isMaster())) {
            return false;
        }
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobId() != null) {
            sb.append("JobId: ").append(jobId()).append(",");
        }
        if (jobState() != null) {
            sb.append("JobState: ").append(jobState()).append(",");
        }
        if (isMaster() != null) {
            sb.append("IsMaster: ").append(isMaster()).append(",");
        }
        if (jobType() != null) {
            sb.append("JobType: ").append(jobType()).append(",");
        }
        if (snowballType() != null) {
            sb.append("SnowballType: ").append(snowballType()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobListEntry> {
        /**
         * <p>
         * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The automatically generated ID for a job, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current state of this job.
         * </p>
         * 
         * @param jobState
         *        The current state of this job.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(String jobState);

        /**
         * <p>
         * The current state of this job.
         * </p>
         * 
         * @param jobState
         *        The current state of this job.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(JobState jobState);

        /**
         * <p>
         * A value that indicates that this job is a master job. A master job represents a successful request to create
         * an export job. Master jobs aren't associated with any Snowballs. Instead, each master job will have at least
         * one job part, and each job part is associated with a Snowball. It might take some time before the job parts
         * associated with a particular master job are listed, because they are created after the master job is created.
         * </p>
         * 
         * @param isMaster
         *        A value that indicates that this job is a master job. A master job represents a successful request to
         *        create an export job. Master jobs aren't associated with any Snowballs. Instead, each master job will
         *        have at least one job part, and each job part is associated with a Snowball. It might take some time
         *        before the job parts associated with a particular master job are listed, because they are created
         *        after the master job is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMaster(Boolean isMaster);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The type of appliance used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of appliance used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of appliance used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of appliance used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The creation date for this job.
         * </p>
         * 
         * @param creationDate
         *        The creation date for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
         * </p>
         * 
         * @param description
         *        The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    private static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobState;

        private Boolean isMaster;

        private String jobType;

        private String snowballType;

        private Instant creationDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(JobListEntry model) {
            setJobId(model.jobId);
            setJobState(model.jobState);
            setIsMaster(model.isMaster);
            setJobType(model.jobType);
            setSnowballType(model.snowballType);
            setCreationDate(model.creationDate);
            setDescription(model.description);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobState() {
            return jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState.toString());
            return this;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        public final Boolean getIsMaster() {
            return isMaster;
        }

        @Override
        public final Builder isMaster(Boolean isMaster) {
            this.isMaster = isMaster;
            return this;
        }

        public final void setIsMaster(Boolean isMaster) {
            this.isMaster = isMaster;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public JobListEntry build() {
            return new JobListEntry(this);
        }
    }
}
