/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.JobMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a specific job including shipping information, job status, and other important metadata.
 * This information is returned as a part of the response syntax of the <code>DescribeJob</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobMetadata implements StructuredPojo, ToCopyableBuilder<JobMetadata.Builder, JobMetadata> {
    private final String jobId;

    private final String jobState;

    private final String jobType;

    private final String snowballType;

    private final Instant creationDate;

    private final JobResource resources;

    private final String description;

    private final String kmsKeyARN;

    private final String roleARN;

    private final String addressId;

    private final ShippingDetails shippingDetails;

    private final String snowballCapacityPreference;

    private final Notification notification;

    private final DataTransfer dataTransferProgress;

    private final JobLogs jobLogInfo;

    private final String clusterId;

    private final String forwardingAddressId;

    private JobMetadata(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.resources = builder.resources;
        this.description = builder.description;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.addressId = builder.addressId;
        this.shippingDetails = builder.shippingDetails;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.notification = builder.notification;
        this.dataTransferProgress = builder.dataTransferProgress;
        this.jobLogInfo = builder.jobLogInfo;
        this.clusterId = builder.clusterId;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The automatically generated ID for a job, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current status of the jobs.
     * </p>
     * 
     * @return The current status of the jobs.
     * @see JobState
     */
    public String jobState() {
        return jobState;
    }

    /**
     * <p>
     * The type of job.
     * </p>
     * 
     * @return The type of job.
     * @see JobType
     */
    public String jobType() {
        return jobType;
    }

    /**
     * <p>
     * The type of appliance used with this job.
     * </p>
     * 
     * @return The type of appliance used with this job.
     * @see SnowballType
     */
    public String snowballType() {
        return snowballType;
    }

    /**
     * <p>
     * The creation date for this job.
     * </p>
     * 
     * @return The creation date for this job.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3 bucket
     * that your transferred data will be exported from or imported into.
     * </p>
     * 
     * @return An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3
     *         bucket that your transferred data will be exported from or imported into.
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * The description of the job, provided at job creation.
     * </p>
     * 
     * @return The description of the job, provided at job creation.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this job. This
     * ARN was created using the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS KMS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this job.
     *         This ARN was created using the <a
     *         href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in
     *         AWS KMS.
     */
    public String kmsKeyARN() {
        return kmsKeyARN;
    }

    /**
     * <p>
     * The role ARN associated with this job. This ARN was created using the <a
     * href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in AWS
     * Identity and Access Management (IAM).
     * </p>
     * 
     * @return The role ARN associated with this job. This ARN was created using the <a
     *         href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *         in AWS Identity and Access Management (IAM).
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ID for the address that you want the Snowball shipped to.
     * </p>
     * 
     * @return The ID for the address that you want the Snowball shipped to.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
     * </p>
     * 
     * @return A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
     */
    public ShippingDetails shippingDetails() {
        return shippingDetails;
    }

    /**
     * <p>
     * The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose between
     * 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
     * </p>
     * 
     * @return The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose
     *         between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
     * @see SnowballCapacity
     */
    public String snowballCapacityPreference() {
        return snowballCapacityPreference;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The
     * <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code>
     * action in the <code>JobMetadata</code> data type.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job.
     *         The <code>Notification</code> object is returned as a part of the response syntax of the
     *         <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * A value that defines the real-time status of a Snowball's data transfer while the appliance is at AWS. This data
     * is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and
     * export jobs.
     * </p>
     * 
     * @return A value that defines the real-time status of a Snowball's data transfer while the appliance is at AWS.
     *         This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for
     *         both import and export jobs.
     */
    public DataTransfer dataTransferProgress() {
        return dataTransferProgress;
    }

    /**
     * <p>
     * Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes
     * available at the end of the import process. For export jobs, your job report typically becomes available while
     * the Snowball for your job part is being delivered to you.
     * </p>
     * 
     * @return Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report
     *         becomes available at the end of the import process. For export jobs, your job report typically becomes
     *         available while the Snowball for your job part is being delivered to you.
     */
    public JobLogs jobLogInfo() {
        return jobLogInfo;
    }

    /**
     * <p>
     * The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field
     * is not supported in most regions.
     * </p>
     * 
     * @return The ID of the address that you want a job shipped to, after it will be shipped to its primary address.
     *         This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobId() == null) ? 0 : jobId().hashCode());
        hashCode = 31 * hashCode + ((jobState() == null) ? 0 : jobState().hashCode());
        hashCode = 31 * hashCode + ((jobType() == null) ? 0 : jobType().hashCode());
        hashCode = 31 * hashCode + ((snowballType() == null) ? 0 : snowballType().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((resources() == null) ? 0 : resources().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((kmsKeyARN() == null) ? 0 : kmsKeyARN().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((addressId() == null) ? 0 : addressId().hashCode());
        hashCode = 31 * hashCode + ((shippingDetails() == null) ? 0 : shippingDetails().hashCode());
        hashCode = 31 * hashCode + ((snowballCapacityPreference() == null) ? 0 : snowballCapacityPreference().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((dataTransferProgress() == null) ? 0 : dataTransferProgress().hashCode());
        hashCode = 31 * hashCode + ((jobLogInfo() == null) ? 0 : jobLogInfo().hashCode());
        hashCode = 31 * hashCode + ((clusterId() == null) ? 0 : clusterId().hashCode());
        hashCode = 31 * hashCode + ((forwardingAddressId() == null) ? 0 : forwardingAddressId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobMetadata)) {
            return false;
        }
        JobMetadata other = (JobMetadata) obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.jobState() == null ^ this.jobState() == null) {
            return false;
        }
        if (other.jobState() != null && !other.jobState().equals(this.jobState())) {
            return false;
        }
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.kmsKeyARN() == null ^ this.kmsKeyARN() == null) {
            return false;
        }
        if (other.kmsKeyARN() != null && !other.kmsKeyARN().equals(this.kmsKeyARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.shippingDetails() == null ^ this.shippingDetails() == null) {
            return false;
        }
        if (other.shippingDetails() != null && !other.shippingDetails().equals(this.shippingDetails())) {
            return false;
        }
        if (other.snowballCapacityPreference() == null ^ this.snowballCapacityPreference() == null) {
            return false;
        }
        if (other.snowballCapacityPreference() != null
                && !other.snowballCapacityPreference().equals(this.snowballCapacityPreference())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.dataTransferProgress() == null ^ this.dataTransferProgress() == null) {
            return false;
        }
        if (other.dataTransferProgress() != null && !other.dataTransferProgress().equals(this.dataTransferProgress())) {
            return false;
        }
        if (other.jobLogInfo() == null ^ this.jobLogInfo() == null) {
            return false;
        }
        if (other.jobLogInfo() != null && !other.jobLogInfo().equals(this.jobLogInfo())) {
            return false;
        }
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        if (other.forwardingAddressId() != null && !other.forwardingAddressId().equals(this.forwardingAddressId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobId() != null) {
            sb.append("JobId: ").append(jobId()).append(",");
        }
        if (jobState() != null) {
            sb.append("JobState: ").append(jobState()).append(",");
        }
        if (jobType() != null) {
            sb.append("JobType: ").append(jobType()).append(",");
        }
        if (snowballType() != null) {
            sb.append("SnowballType: ").append(snowballType()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (resources() != null) {
            sb.append("Resources: ").append(resources()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(kmsKeyARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (addressId() != null) {
            sb.append("AddressId: ").append(addressId()).append(",");
        }
        if (shippingDetails() != null) {
            sb.append("ShippingDetails: ").append(shippingDetails()).append(",");
        }
        if (snowballCapacityPreference() != null) {
            sb.append("SnowballCapacityPreference: ").append(snowballCapacityPreference()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (dataTransferProgress() != null) {
            sb.append("DataTransferProgress: ").append(dataTransferProgress()).append(",");
        }
        if (jobLogInfo() != null) {
            sb.append("JobLogInfo: ").append(jobLogInfo()).append(",");
        }
        if (clusterId() != null) {
            sb.append("ClusterId: ").append(clusterId()).append(",");
        }
        if (forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(forwardingAddressId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobMetadata> {
        /**
         * <p>
         * The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The automatically generated ID for a job, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current status of the jobs.
         * </p>
         * 
         * @param jobState
         *        The current status of the jobs.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(String jobState);

        /**
         * <p>
         * The current status of the jobs.
         * </p>
         * 
         * @param jobState
         *        The current status of the jobs.
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder jobState(JobState jobState);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of job.
         * </p>
         * 
         * @param jobType
         *        The type of job.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The type of appliance used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of appliance used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(String snowballType);

        /**
         * <p>
         * The type of appliance used with this job.
         * </p>
         * 
         * @param snowballType
         *        The type of appliance used with this job.
         * @see SnowballType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballType
         */
        Builder snowballType(SnowballType snowballType);

        /**
         * <p>
         * The creation date for this job.
         * </p>
         * 
         * @param creationDate
         *        The creation date for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3
         * bucket that your transferred data will be exported from or imported into.
         * </p>
         * 
         * @param resources
         *        An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon
         *        S3 bucket that your transferred data will be exported from or imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * The description of the job, provided at job creation.
         * </p>
         * 
         * @param description
         *        The description of the job, provided at job creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this job.
         * This ARN was created using the <a
         * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS
         * KMS.
         * </p>
         * 
         * @param kmsKeyARN
         *        The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this
         *        job. This ARN was created using the <a
         *        href="http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action
         *        in AWS KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyARN(String kmsKeyARN);

        /**
         * <p>
         * The role ARN associated with this job. This ARN was created using the <a
         * href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in
         * AWS Identity and Access Management (IAM).
         * </p>
         * 
         * @param roleARN
         *        The role ARN associated with this job. This ARN was created using the <a
         *        href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
         *        action in AWS Identity and Access Management (IAM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ID for the address that you want the Snowball shipped to.
         * </p>
         * 
         * @param addressId
         *        The ID for the address that you want the Snowball shipped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
         * </p>
         * 
         * @param shippingDetails
         *        A job's shipping information, including inbound and outbound tracking numbers and shipping speed
         *        options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingDetails(ShippingDetails shippingDetails);

        /**
         * <p>
         * The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose
         * between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The Snowball capacity preference for this job, specified at job creation. In US regions, you can
         *        choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(String snowballCapacityPreference);

        /**
         * <p>
         * The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose
         * between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The Snowball capacity preference for this job, specified at job creation. In US regions, you can
         *        choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The
         * <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code>
         * action in the <code>JobMetadata</code> data type.
         * </p>
         * 
         * @param notification
         *        The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific
         *        job. The <code>Notification</code> object is returned as a part of the response syntax of the
         *        <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * A value that defines the real-time status of a Snowball's data transfer while the appliance is at AWS. This
         * data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both
         * import and export jobs.
         * </p>
         * 
         * @param dataTransferProgress
         *        A value that defines the real-time status of a Snowball's data transfer while the appliance is at AWS.
         *        This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>,
         *        for both import and export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferProgress(DataTransfer dataTransferProgress);

        /**
         * <p>
         * Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes
         * available at the end of the import process. For export jobs, your job report typically becomes available
         * while the Snowball for your job part is being delivered to you.
         * </p>
         * 
         * @param jobLogInfo
         *        Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report
         *        becomes available at the end of the import process. For export jobs, your job report typically becomes
         *        available while the Snowball for your job part is being delivered to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobLogInfo(JobLogs jobLogInfo);

        /**
         * <p>
         * The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param clusterId
         *        The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This
         * field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The ID of the address that you want a job shipped to, after it will be shipped to its primary address.
         *        This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);
    }

    private static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobState;

        private String jobType;

        private String snowballType;

        private Instant creationDate;

        private JobResource resources;

        private String description;

        private String kmsKeyARN;

        private String roleARN;

        private String addressId;

        private ShippingDetails shippingDetails;

        private String snowballCapacityPreference;

        private Notification notification;

        private DataTransfer dataTransferProgress;

        private JobLogs jobLogInfo;

        private String clusterId;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobMetadata model) {
            setJobId(model.jobId);
            setJobState(model.jobState);
            setJobType(model.jobType);
            setSnowballType(model.snowballType);
            setCreationDate(model.creationDate);
            setResources(model.resources);
            setDescription(model.description);
            setKmsKeyARN(model.kmsKeyARN);
            setRoleARN(model.roleARN);
            setAddressId(model.addressId);
            setShippingDetails(model.shippingDetails);
            setSnowballCapacityPreference(model.snowballCapacityPreference);
            setNotification(model.notification);
            setDataTransferProgress(model.dataTransferProgress);
            setJobLogInfo(model.jobLogInfo);
            setClusterId(model.clusterId);
            setForwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobState() {
            return jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState.toString());
            return this;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballType() {
            return snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final JobResource getResources() {
            return resources;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource resources) {
            this.resources = resources;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyARN() {
            return kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final ShippingDetails getShippingDetails() {
            return shippingDetails;
        }

        @Override
        public final Builder shippingDetails(ShippingDetails shippingDetails) {
            this.shippingDetails = shippingDetails;
            return this;
        }

        public final void setShippingDetails(ShippingDetails shippingDetails) {
            this.shippingDetails = shippingDetails;
        }

        public final String getSnowballCapacityPreference() {
            return snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final Notification getNotification() {
            return notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final DataTransfer getDataTransferProgress() {
            return dataTransferProgress;
        }

        @Override
        public final Builder dataTransferProgress(DataTransfer dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
            return this;
        }

        public final void setDataTransferProgress(DataTransfer dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
        }

        public final JobLogs getJobLogInfo() {
            return jobLogInfo;
        }

        @Override
        public final Builder jobLogInfo(JobLogs jobLogInfo) {
            this.jobLogInfo = jobLogInfo;
            return this;
        }

        public final void setJobLogInfo(JobLogs jobLogInfo) {
            this.jobLogInfo = jobLogInfo;
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public JobMetadata build() {
            return new JobMetadata(this);
        }
    }
}
