/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.JobResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3
 * bucket that your transferred data will be exported from or imported into.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobResource implements StructuredPojo, ToCopyableBuilder<JobResource.Builder, JobResource> {
    private final List<S3Resource> s3Resources;

    private final List<LambdaResource> lambdaResources;

    private JobResource(BuilderImpl builder) {
        this.s3Resources = builder.s3Resources;
        this.lambdaResources = builder.lambdaResources;
    }

    /**
     * <p>
     * An array of <code>S3Resource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>S3Resource</code> objects.
     */
    public List<S3Resource> s3Resources() {
        return s3Resources;
    }

    /**
     * <p>
     * The Python-language Lambda functions for this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Python-language Lambda functions for this job.
     */
    public List<LambdaResource> lambdaResources() {
        return lambdaResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((s3Resources() == null) ? 0 : s3Resources().hashCode());
        hashCode = 31 * hashCode + ((lambdaResources() == null) ? 0 : lambdaResources().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobResource)) {
            return false;
        }
        JobResource other = (JobResource) obj;
        if (other.s3Resources() == null ^ this.s3Resources() == null) {
            return false;
        }
        if (other.s3Resources() != null && !other.s3Resources().equals(this.s3Resources())) {
            return false;
        }
        if (other.lambdaResources() == null ^ this.lambdaResources() == null) {
            return false;
        }
        if (other.lambdaResources() != null && !other.lambdaResources().equals(this.lambdaResources())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (s3Resources() != null) {
            sb.append("S3Resources: ").append(s3Resources()).append(",");
        }
        if (lambdaResources() != null) {
            sb.append("LambdaResources: ").append(lambdaResources()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobResource> {
        /**
         * <p>
         * An array of <code>S3Resource</code> objects.
         * </p>
         * 
         * @param s3Resources
         *        An array of <code>S3Resource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(Collection<S3Resource> s3Resources);

        /**
         * <p>
         * An array of <code>S3Resource</code> objects.
         * </p>
         * 
         * @param s3Resources
         *        An array of <code>S3Resource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(S3Resource... s3Resources);

        /**
         * <p>
         * The Python-language Lambda functions for this job.
         * </p>
         * 
         * @param lambdaResources
         *        The Python-language Lambda functions for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaResources(Collection<LambdaResource> lambdaResources);

        /**
         * <p>
         * The Python-language Lambda functions for this job.
         * </p>
         * 
         * @param lambdaResources
         *        The Python-language Lambda functions for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaResources(LambdaResource... lambdaResources);
    }

    private static final class BuilderImpl implements Builder {
        private List<S3Resource> s3Resources;

        private List<LambdaResource> lambdaResources;

        private BuilderImpl() {
        }

        private BuilderImpl(JobResource model) {
            setS3Resources(model.s3Resources);
            setLambdaResources(model.lambdaResources);
        }

        public final Collection<S3Resource> getS3Resources() {
            return s3Resources;
        }

        @Override
        public final Builder s3Resources(Collection<S3Resource> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3Resource... s3Resources) {
            s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        public final void setS3Resources(Collection<S3Resource> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copy(s3Resources);
        }

        public final Collection<LambdaResource> getLambdaResources() {
            return lambdaResources;
        }

        @Override
        public final Builder lambdaResources(Collection<LambdaResource> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copy(lambdaResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(LambdaResource... lambdaResources) {
            lambdaResources(Arrays.asList(lambdaResources));
            return this;
        }

        public final void setLambdaResources(Collection<LambdaResource> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copy(lambdaResources);
        }

        @Override
        public JobResource build() {
            return new JobResource(this);
        }
    }
}
