/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.KeyRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a key range. For export jobs, a <code>S3Resource</code> object can have an optional <code>KeyRange</code>
 * value. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an
 * inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyRange implements StructuredPojo, ToCopyableBuilder<KeyRange.Builder, KeyRange> {
    private final String beginMarker;

    private final String endMarker;

    private KeyRange(BuilderImpl builder) {
        this.beginMarker = builder.beginMarker;
        this.endMarker = builder.endMarker;
    }

    /**
     * <p>
     * The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
     * </p>
     * 
     * @return The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary
     *         sorted.
     */
    public String beginMarker() {
        return beginMarker;
    }

    /**
     * <p>
     * The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
     * </p>
     * 
     * @return The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
     */
    public String endMarker() {
        return endMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((beginMarker() == null) ? 0 : beginMarker().hashCode());
        hashCode = 31 * hashCode + ((endMarker() == null) ? 0 : endMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyRange)) {
            return false;
        }
        KeyRange other = (KeyRange) obj;
        if (other.beginMarker() == null ^ this.beginMarker() == null) {
            return false;
        }
        if (other.beginMarker() != null && !other.beginMarker().equals(this.beginMarker())) {
            return false;
        }
        if (other.endMarker() == null ^ this.endMarker() == null) {
            return false;
        }
        if (other.endMarker() != null && !other.endMarker().equals(this.endMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (beginMarker() != null) {
            sb.append("BeginMarker: ").append(beginMarker()).append(",");
        }
        if (endMarker() != null) {
            sb.append("EndMarker: ").append(endMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KeyRange> {
        /**
         * <p>
         * The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
         * </p>
         * 
         * @param beginMarker
         *        The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary
         *        sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginMarker(String beginMarker);

        /**
         * <p>
         * The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
         * </p>
         * 
         * @param endMarker
         *        The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary
         *        sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endMarker(String endMarker);
    }

    private static final class BuilderImpl implements Builder {
        private String beginMarker;

        private String endMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyRange model) {
            setBeginMarker(model.beginMarker);
            setEndMarker(model.endMarker);
        }

        public final String getBeginMarker() {
            return beginMarker;
        }

        @Override
        public final Builder beginMarker(String beginMarker) {
            this.beginMarker = beginMarker;
            return this;
        }

        public final void setBeginMarker(String beginMarker) {
            this.beginMarker = beginMarker;
        }

        public final String getEndMarker() {
            return endMarker;
        }

        @Override
        public final Builder endMarker(String endMarker) {
            this.endMarker = endMarker;
            return this;
        }

        public final void setEndMarker(String endMarker) {
            this.endMarker = endMarker;
        }

        @Override
        public KeyRange build() {
            return new KeyRange(this);
        }
    }
}
