/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.LambdaResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaResource implements StructuredPojo, ToCopyableBuilder<LambdaResource.Builder, LambdaResource> {
    private final String lambdaArn;

    private final List<EventTriggerDefinition> eventTriggers;

    private LambdaResource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.eventTriggers = builder.eventTriggers;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object actions on the
     * associated local Amazon S3 resource.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object
     *         actions on the associated local Amazon S3 resource.
     */
    public String lambdaArn() {
        return lambdaArn;
    }

    /**
     * <p>
     * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with this
     * job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated
     *         with this job.
     */
    public List<EventTriggerDefinition> eventTriggers() {
        return eventTriggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lambdaArn() == null) ? 0 : lambdaArn().hashCode());
        hashCode = 31 * hashCode + ((eventTriggers() == null) ? 0 : eventTriggers().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaResource)) {
            return false;
        }
        LambdaResource other = (LambdaResource) obj;
        if (other.lambdaArn() == null ^ this.lambdaArn() == null) {
            return false;
        }
        if (other.lambdaArn() != null && !other.lambdaArn().equals(this.lambdaArn())) {
            return false;
        }
        if (other.eventTriggers() == null ^ this.eventTriggers() == null) {
            return false;
        }
        if (other.eventTriggers() != null && !other.eventTriggers().equals(this.eventTriggers())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lambdaArn() != null) {
            sb.append("LambdaArn: ").append(lambdaArn()).append(",");
        }
        if (eventTriggers() != null) {
            sb.append("EventTriggers: ").append(eventTriggers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object actions on
         * the associated local Amazon S3 resource.
         * </p>
         * 
         * @param lambdaArn
         *        An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object
         *        actions on the associated local Amazon S3 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(EventTriggerDefinition... eventTriggers);
    }

    private static final class BuilderImpl implements Builder {
        private String lambdaArn;

        private List<EventTriggerDefinition> eventTriggers;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaResource model) {
            setLambdaArn(model.lambdaArn);
            setEventTriggers(model.eventTriggers);
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        public final Collection<EventTriggerDefinition> getEventTriggers() {
            return eventTriggers;
        }

        @Override
        public final Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(EventTriggerDefinition... eventTriggers) {
            eventTriggers(Arrays.asList(eventTriggers));
            return this;
        }

        public final void setEventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
        }

        @Override
        public LambdaResource build() {
            return new LambdaResource(this);
        }
    }
}
