/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.S3ResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from
 * or imported into. For export jobs, this object can have an optional <code>KeyRange</code> value. The length of the
 * range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive
 * <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Resource implements StructuredPojo, ToCopyableBuilder<S3Resource.Builder, S3Resource> {
    private final String bucketArn;

    private final KeyRange keyRange;

    private S3Resource(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.keyRange = builder.keyRange;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon S3 bucket.
     */
    public String bucketArn() {
        return bucketArn;
    }

    /**
     * <p>
     * For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The length
     * of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive
     * <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
     * </p>
     * 
     * @return For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket.
     *         The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>,
     *         an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
     */
    public KeyRange keyRange() {
        return keyRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucketArn() == null) ? 0 : bucketArn().hashCode());
        hashCode = 31 * hashCode + ((keyRange() == null) ? 0 : keyRange().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Resource)) {
            return false;
        }
        S3Resource other = (S3Resource) obj;
        if (other.bucketArn() == null ^ this.bucketArn() == null) {
            return false;
        }
        if (other.bucketArn() != null && !other.bucketArn().equals(this.bucketArn())) {
            return false;
        }
        if (other.keyRange() == null ^ this.keyRange() == null) {
            return false;
        }
        if (other.keyRange() != null && !other.keyRange().equals(this.keyRange())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucketArn() != null) {
            sb.append("BucketArn: ").append(bucketArn()).append(",");
        }
        if (keyRange() != null) {
            sb.append("KeyRange: ").append(keyRange()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3Resource> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon S3 bucket.
         * </p>
         * 
         * @param bucketArn
         *        The Amazon Resource Name (ARN) of an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketArn(String bucketArn);

        /**
         * <p>
         * For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The
         * length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an
         * inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
         * </p>
         * 
         * @param keyRange
         *        For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket.
         *        The length of the range is defined at job creation, and has either an inclusive
         *        <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary
         *        sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRange(KeyRange keyRange);
    }

    private static final class BuilderImpl implements Builder {
        private String bucketArn;

        private KeyRange keyRange;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Resource model) {
            setBucketArn(model.bucketArn);
            setKeyRange(model.keyRange);
        }

        public final String getBucketArn() {
            return bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        public final KeyRange getKeyRange() {
            return keyRange;
        }

        @Override
        public final Builder keyRange(KeyRange keyRange) {
            this.keyRange = keyRange;
            return this;
        }

        public final void setKeyRange(KeyRange keyRange) {
            this.keyRange = keyRange;
        }

        @Override
        public S3Resource build() {
            return new S3Resource(this);
        }
    }
}
