/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.ShippingDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ShippingDetails implements StructuredPojo, ToCopyableBuilder<ShippingDetails.Builder, ShippingDetails> {
    private final String shippingOption;

    private final Shipment inboundShipment;

    private final Shipment outboundShipment;

    private ShippingDetails(BuilderImpl builder) {
        this.shippingOption = builder.shippingOption;
        this.inboundShipment = builder.inboundShipment;
        this.outboundShipment = builder.outboundShipment;
    }

    /**
     * <p>
     * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snowball from the
     * job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snowballs are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snowball from
     *         the job's creation date. This speed represents how quickly it moves to its destination while in transit.
     *         Regional shipping speeds are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
     *         about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
     *         delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
     *         typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snowballs are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */
    public String shippingOption() {
        return shippingOption;
    }

    /**
     * <p>
     * The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being delivered to the address that
     * you specified for a particular job.
     * </p>
     * 
     * @return The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being delivered to the
     *         address that you specified for a particular job.
     */
    public Shipment inboundShipment() {
        return inboundShipment;
    }

    /**
     * <p>
     * The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being returned to AWS for a
     * particular job.
     * </p>
     * 
     * @return The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being returned to AWS for a
     *         particular job.
     */
    public Shipment outboundShipment() {
        return outboundShipment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((shippingOption() == null) ? 0 : shippingOption().hashCode());
        hashCode = 31 * hashCode + ((inboundShipment() == null) ? 0 : inboundShipment().hashCode());
        hashCode = 31 * hashCode + ((outboundShipment() == null) ? 0 : outboundShipment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShippingDetails)) {
            return false;
        }
        ShippingDetails other = (ShippingDetails) obj;
        if (other.shippingOption() == null ^ this.shippingOption() == null) {
            return false;
        }
        if (other.shippingOption() != null && !other.shippingOption().equals(this.shippingOption())) {
            return false;
        }
        if (other.inboundShipment() == null ^ this.inboundShipment() == null) {
            return false;
        }
        if (other.inboundShipment() != null && !other.inboundShipment().equals(this.inboundShipment())) {
            return false;
        }
        if (other.outboundShipment() == null ^ this.outboundShipment() == null) {
            return false;
        }
        if (other.outboundShipment() != null && !other.outboundShipment().equals(this.outboundShipment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (shippingOption() != null) {
            sb.append("ShippingOption: ").append(shippingOption()).append(",");
        }
        if (inboundShipment() != null) {
            sb.append("InboundShipment: ").append(inboundShipment()).append(",");
        }
        if (outboundShipment() != null) {
            sb.append("OutboundShipment: ").append(outboundShipment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShippingDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ShippingDetails> {
        /**
         * <p>
         * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snowball from the
         * job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional
         * shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowballs are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the United States of America (US), you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snowball
         *        from the job's creation date. This speed represents how quickly it moves to its destination while in
         *        transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express
         *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
         *        which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowballs are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snowball from the
         * job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional
         * shipping speeds are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in
         * about a day.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are
         * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which
         * typically takes less than a week, one way.
         * </p>
         * </li>
         * <li>
         * <p>
         * In India, Snowballs are delivered in one to seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the United States of America (US), you have access to one-day shipping and two-day shipping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shippingOption
         *        The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snowball
         *        from the job's creation date. This speed represents how quickly it moves to its destination while in
         *        transit. Regional shipping speeds are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered
         *        in about a day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express
         *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
         *        which typically takes less than a week, one way.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In India, Snowballs are delivered in one to seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
         *        </p>
         *        </li>
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being delivered to the address
         * that you specified for a particular job.
         * </p>
         * 
         * @param inboundShipment
         *        The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being delivered to the
         *        address that you specified for a particular job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundShipment(Shipment inboundShipment);

        /**
         * <p>
         * The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being returned to AWS for a
         * particular job.
         * </p>
         * 
         * @param outboundShipment
         *        The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being returned to AWS
         *        for a particular job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundShipment(Shipment outboundShipment);
    }

    private static final class BuilderImpl implements Builder {
        private String shippingOption;

        private Shipment inboundShipment;

        private Shipment outboundShipment;

        private BuilderImpl() {
        }

        private BuilderImpl(ShippingDetails model) {
            setShippingOption(model.shippingOption);
            setInboundShipment(model.inboundShipment);
            setOutboundShipment(model.outboundShipment);
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Shipment getInboundShipment() {
            return inboundShipment;
        }

        @Override
        public final Builder inboundShipment(Shipment inboundShipment) {
            this.inboundShipment = inboundShipment;
            return this;
        }

        public final void setInboundShipment(Shipment inboundShipment) {
            this.inboundShipment = inboundShipment;
        }

        public final Shipment getOutboundShipment() {
            return outboundShipment;
        }

        @Override
        public final Builder outboundShipment(Shipment outboundShipment) {
            this.outboundShipment = outboundShipment;
            return this;
        }

        public final void setOutboundShipment(Shipment outboundShipment) {
            this.outboundShipment = outboundShipment;
        }

        @Override
        public ShippingDetails build() {
            return new ShippingDetails(this);
        }
    }
}
