/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.model.ClusterMetadata;
import software.amazon.awssdk.services.snowball.transform.JobResourceUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.NotificationUnmarshaller;

public class ClusterMetadataUnmarshaller
implements Unmarshaller<ClusterMetadata, JsonUnmarshallerContext> {
    private static final ClusterMetadataUnmarshaller INSTANCE = new ClusterMetadataUnmarshaller();

    public ClusterMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        ClusterMetadata.Builder clusterMetadataBuilder = ClusterMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ClusterId", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.clusterId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyARN", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.kmsKeyARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.roleARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClusterState", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.clusterState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JobType", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.jobType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SnowballType", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.snowballType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.creationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Resources", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.resources(JobResourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AddressId", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.addressId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ShippingOption", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.shippingOption((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Notification", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.notification(NotificationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ForwardingAddressId", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.forwardingAddressId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ClusterMetadata)clusterMetadataBuilder.build();
    }

    public static ClusterMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

