/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.JobMetadata;

@SdkInternalApi
public class JobMetadataMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").build();
    private static final MarshallingInfo<String> JOBSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobState").build();
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").build();
    private static final MarshallingInfo<StructuredPojo> SHIPPINGDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingDetails").build();
    private static final MarshallingInfo<String> SNOWBALLCAPACITYPREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballCapacityPreference").build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").build();
    private static final MarshallingInfo<StructuredPojo> DATATRANSFERPROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTransferProgress").build();
    private static final MarshallingInfo<StructuredPojo> JOBLOGINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobLogInfo").build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").build();
    private static final JobMetadataMarshaller INSTANCE = new JobMetadataMarshaller();

    public static JobMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobMetadata jobMetadata, ProtocolMarshaller protocolMarshaller) {
        if (jobMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobMetadata.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.jobState(), JOBSTATE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.jobType(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.snowballType(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.kmsKeyARN(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.shippingDetails(), SHIPPINGDETAILS_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.snowballCapacityPreference(), SNOWBALLCAPACITYPREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.dataTransferProgress(), DATATRANSFERPROGRESS_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.jobLogInfo(), JOBLOGINFO_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)jobMetadata.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

