/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.ClusterState;
import software.amazon.awssdk.services.snowball.transform.ClusterListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, ClusterListEntry> {
    private final String clusterId;
    private final String clusterState;
    private final Instant creationDate;
    private final String description;

    private ClusterListEntry(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.clusterState = builder.clusterState;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String clusterState() {
        return this.clusterState;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.clusterState() == null ? 0 : this.clusterState().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterListEntry)) {
            return false;
        }
        ClusterListEntry other = (ClusterListEntry)obj;
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.clusterState() == null ^ this.clusterState() == null) {
            return false;
        }
        if (other.clusterState() != null && !other.clusterState().equals(this.clusterState())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.clusterState() != null) {
            sb.append("ClusterState: ").append(this.clusterState()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String clusterState;
        private Instant creationDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterListEntry model) {
            this.setClusterId(model.clusterId);
            this.setClusterState(model.clusterState);
            this.setCreationDate(model.creationDate);
            this.setDescription(model.description);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getClusterState() {
            return this.clusterState;
        }

        @Override
        public final Builder clusterState(String clusterState) {
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public final Builder clusterState(ClusterState clusterState) {
            this.clusterState(clusterState.toString());
            return this;
        }

        public final void setClusterState(String clusterState) {
            this.clusterState = clusterState;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public ClusterListEntry build() {
            return new ClusterListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterListEntry> {
        public Builder clusterId(String var1);

        public Builder clusterState(String var1);

        public Builder clusterState(ClusterState var1);

        public Builder creationDate(Instant var1);

        public Builder description(String var1);
    }
}

