/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum JobState {
    New("New"),
    PreparingAppliance("PreparingAppliance"),
    PreparingShipment("PreparingShipment"),
    InTransitToCustomer("InTransitToCustomer"),
    WithCustomer("WithCustomer"),
    InTransitToAWS("InTransitToAWS"),
    WithAWS("WithAWS"),
    InProgress("InProgress"),
    Complete("Complete"),
    Cancelled("Cancelled"),
    Listing("Listing"),
    Pending("Pending");

    private final String value;

    private JobState(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static JobState fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(JobState.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

