/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.snowball.model.JobListEntry;
import software.amazon.awssdk.services.snowball.model.JobListEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClusterJobsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListClusterJobsResponse> {
    private final List<JobListEntry> jobListEntries;
    private final String nextToken;

    private ListClusterJobsResponse(BuilderImpl builder) {
        this.jobListEntries = builder.jobListEntries;
        this.nextToken = builder.nextToken;
    }

    public List<JobListEntry> jobListEntries() {
        return this.jobListEntries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobListEntries() == null ? 0 : this.jobListEntries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterJobsResponse)) {
            return false;
        }
        ListClusterJobsResponse other = (ListClusterJobsResponse)((Object)obj);
        if (other.jobListEntries() == null ^ this.jobListEntries() == null) {
            return false;
        }
        if (other.jobListEntries() != null && !other.jobListEntries().equals(this.jobListEntries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobListEntries() != null) {
            sb.append("JobListEntries: ").append(this.jobListEntries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<JobListEntry> jobListEntries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterJobsResponse model) {
            this.setJobListEntries(model.jobListEntries);
            this.setNextToken(model.nextToken);
        }

        public final Collection<JobListEntry> getJobListEntries() {
            return this.jobListEntries;
        }

        @Override
        public final Builder jobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(JobListEntry ... jobListEntries) {
            this.jobListEntries(Arrays.asList(jobListEntries));
            return this;
        }

        public final void setJobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListClusterJobsResponse build() {
            return new ListClusterJobsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListClusterJobsResponse> {
        public Builder jobListEntries(Collection<JobListEntry> var1);

        public Builder jobListEntries(JobListEntry ... var1);

        public Builder nextToken(String var1);
    }
}

