/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.JobLogs;

@SdkInternalApi
public class JobLogsMarshaller {
    private static final MarshallingInfo<String> JOBCOMPLETIONREPORTURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobCompletionReportURI").build();
    private static final MarshallingInfo<String> JOBSUCCESSLOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobSuccessLogURI").build();
    private static final MarshallingInfo<String> JOBFAILURELOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobFailureLogURI").build();
    private static final JobLogsMarshaller INSTANCE = new JobLogsMarshaller();

    public static JobLogsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobLogs jobLogs, ProtocolMarshaller protocolMarshaller) {
        if (jobLogs == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobLogs.jobCompletionReportURI(), JOBCOMPLETIONREPORTURI_BINDING);
            protocolMarshaller.marshall((Object)jobLogs.jobSuccessLogURI(), JOBSUCCESSLOGURI_BINDING);
            protocolMarshaller.marshall((Object)jobLogs.jobFailureLogURI(), JOBFAILURELOGURI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

