/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.transform.LambdaResourceUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.S3ResourceUnmarshaller;

public class JobResourceUnmarshaller
implements Unmarshaller<JobResource, JsonUnmarshallerContext> {
    private static final JobResourceUnmarshaller INSTANCE = new JobResourceUnmarshaller();

    public JobResource unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobResource.Builder jobResourceBuilder = JobResource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3Resources", targetDepth)) {
                    context.nextToken();
                    jobResourceBuilder.s3Resources(new ListUnmarshaller((Unmarshaller)S3ResourceUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("LambdaResources", targetDepth)) {
                    context.nextToken();
                    jobResourceBuilder.lambdaResources(new ListUnmarshaller((Unmarshaller)LambdaResourceUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JobResource)jobResourceBuilder.build();
    }

    public static JobResourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

