/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.model.KeyRange;

public class KeyRangeUnmarshaller
implements Unmarshaller<KeyRange, JsonUnmarshallerContext> {
    private static final KeyRangeUnmarshaller INSTANCE = new KeyRangeUnmarshaller();

    public KeyRange unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyRange.Builder keyRangeBuilder = KeyRange.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BeginMarker", targetDepth)) {
                    context.nextToken();
                    keyRangeBuilder.beginMarker((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndMarker", targetDepth)) {
                    context.nextToken();
                    keyRangeBuilder.endMarker((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeyRange)keyRangeBuilder.build();
    }

    public static KeyRangeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

