/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.model.Notification;

public class NotificationUnmarshaller
implements Unmarshaller<Notification, JsonUnmarshallerContext> {
    private static final NotificationUnmarshaller INSTANCE = new NotificationUnmarshaller();

    public Notification unmarshall(JsonUnmarshallerContext context) throws Exception {
        Notification.Builder notificationBuilder = Notification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SnsTopicARN", targetDepth)) {
                    context.nextToken();
                    notificationBuilder.snsTopicARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JobStatesToNotify", targetDepth)) {
                    context.nextToken();
                    notificationBuilder.jobStatesToNotify(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("NotifyAll", targetDepth)) {
                    context.nextToken();
                    notificationBuilder.notifyAllJobStates((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Notification)notificationBuilder.build();
    }

    public static NotificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

