/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.ClusterListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a cluster's state, a cluster's ID, and other important information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ClusterListEntry implements StructuredPojo, ToCopyableBuilder<ClusterListEntry.Builder, ClusterListEntry> {
    private final String clusterId;

    private final String clusterState;

    private final Instant creationDate;

    private final String description;

    private ClusterListEntry(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.clusterState = builder.clusterState;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The 39-character ID for the cluster that you want to list, for example
     * <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The 39-character ID for the cluster that you want to list, for example
     *         <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The current state of this cluster. For information about the state of a specific node, see
     * <a>JobListEntry$JobState</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterState} will
     * return {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStateString}.
     * </p>
     * 
     * @return The current state of this cluster. For information about the state of a specific node, see
     *         <a>JobListEntry$JobState</a>.
     * @see ClusterState
     */
    public ClusterState clusterState() {
        return ClusterState.fromValue(clusterState);
    }

    /**
     * <p>
     * The current state of this cluster. For information about the state of a specific node, see
     * <a>JobListEntry$JobState</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterState} will
     * return {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStateString}.
     * </p>
     * 
     * @return The current state of this cluster. For information about the state of a specific node, see
     *         <a>JobListEntry$JobState</a>.
     * @see ClusterState
     */
    public String clusterStateString() {
        return clusterState;
    }

    /**
     * <p>
     * The creation date for this cluster.
     * </p>
     * 
     * @return The creation date for this cluster.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.
     * </p>
     * 
     * @return Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clusterId() == null) ? 0 : clusterId().hashCode());
        hashCode = 31 * hashCode + ((clusterStateString() == null) ? 0 : clusterStateString().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterListEntry)) {
            return false;
        }
        ClusterListEntry other = (ClusterListEntry) obj;
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.clusterStateString() == null ^ this.clusterStateString() == null) {
            return false;
        }
        if (other.clusterStateString() != null && !other.clusterStateString().equals(this.clusterStateString())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clusterId() != null) {
            sb.append("ClusterId: ").append(clusterId()).append(",");
        }
        if (clusterStateString() != null) {
            sb.append("ClusterState: ").append(clusterStateString()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.of(clazz.cast(clusterId()));
        case "ClusterState":
            return Optional.of(clazz.cast(clusterStateString()));
        case "CreationDate":
            return Optional.of(clazz.cast(creationDate()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ClusterListEntry> {
        /**
         * <p>
         * The 39-character ID for the cluster that you want to list, for example
         * <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param clusterId
         *        The 39-character ID for the cluster that you want to list, for example
         *        <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The current state of this cluster. For information about the state of a specific node, see
         * <a>JobListEntry$JobState</a>.
         * </p>
         * 
         * @param clusterState
         *        The current state of this cluster. For information about the state of a specific node, see
         *        <a>JobListEntry$JobState</a>.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder clusterState(String clusterState);

        /**
         * <p>
         * The current state of this cluster. For information about the state of a specific node, see
         * <a>JobListEntry$JobState</a>.
         * </p>
         * 
         * @param clusterState
         *        The current state of this cluster. For information about the state of a specific node, see
         *        <a>JobListEntry$JobState</a>.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder clusterState(ClusterState clusterState);

        /**
         * <p>
         * The creation date for this cluster.
         * </p>
         * 
         * @param creationDate
         *        The creation date for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.
         * </p>
         * 
         * @param description
         *        Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String clusterId;

        private String clusterState;

        private Instant creationDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterListEntry model) {
            clusterId(model.clusterId);
            clusterState(model.clusterState);
            creationDate(model.creationDate);
            description(model.description);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getClusterState() {
            return clusterState;
        }

        @Override
        public final Builder clusterState(String clusterState) {
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public final Builder clusterState(ClusterState clusterState) {
            this.clusterState(clusterState.toString());
            return this;
        }

        public final void setClusterState(String clusterState) {
            this.clusterState = clusterState;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public ClusterListEntry build() {
            return new ClusterListEntry(this);
        }
    }
}
