/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.DataTransferMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the real-time status of a Snowball's data transfer while the appliance is at AWS. This data is only available
 * while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DataTransfer implements StructuredPojo, ToCopyableBuilder<DataTransfer.Builder, DataTransfer> {
    private final Long bytesTransferred;

    private final Long objectsTransferred;

    private final Long totalBytes;

    private final Long totalObjects;

    private DataTransfer(BuilderImpl builder) {
        this.bytesTransferred = builder.bytesTransferred;
        this.objectsTransferred = builder.objectsTransferred;
        this.totalBytes = builder.totalBytes;
        this.totalObjects = builder.totalObjects;
    }

    /**
     * <p>
     * The number of bytes transferred between a Snowball and Amazon S3.
     * </p>
     * 
     * @return The number of bytes transferred between a Snowball and Amazon S3.
     */
    public Long bytesTransferred() {
        return bytesTransferred;
    }

    /**
     * <p>
     * The number of objects transferred between a Snowball and Amazon S3.
     * </p>
     * 
     * @return The number of objects transferred between a Snowball and Amazon S3.
     */
    public Long objectsTransferred() {
        return objectsTransferred;
    }

    /**
     * <p>
     * The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until all
     * the keys that will be transferred have been listed.
     * </p>
     * 
     * @return The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero)
     *         until all the keys that will be transferred have been listed.
     */
    public Long totalBytes() {
        return totalBytes;
    }

    /**
     * <p>
     * The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until
     * all the keys that will be transferred have been listed.
     * </p>
     * 
     * @return The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0
     *         (zero) until all the keys that will be transferred have been listed.
     */
    public Long totalObjects() {
        return totalObjects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bytesTransferred() == null) ? 0 : bytesTransferred().hashCode());
        hashCode = 31 * hashCode + ((objectsTransferred() == null) ? 0 : objectsTransferred().hashCode());
        hashCode = 31 * hashCode + ((totalBytes() == null) ? 0 : totalBytes().hashCode());
        hashCode = 31 * hashCode + ((totalObjects() == null) ? 0 : totalObjects().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransfer)) {
            return false;
        }
        DataTransfer other = (DataTransfer) obj;
        if (other.bytesTransferred() == null ^ this.bytesTransferred() == null) {
            return false;
        }
        if (other.bytesTransferred() != null && !other.bytesTransferred().equals(this.bytesTransferred())) {
            return false;
        }
        if (other.objectsTransferred() == null ^ this.objectsTransferred() == null) {
            return false;
        }
        if (other.objectsTransferred() != null && !other.objectsTransferred().equals(this.objectsTransferred())) {
            return false;
        }
        if (other.totalBytes() == null ^ this.totalBytes() == null) {
            return false;
        }
        if (other.totalBytes() != null && !other.totalBytes().equals(this.totalBytes())) {
            return false;
        }
        if (other.totalObjects() == null ^ this.totalObjects() == null) {
            return false;
        }
        if (other.totalObjects() != null && !other.totalObjects().equals(this.totalObjects())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bytesTransferred() != null) {
            sb.append("BytesTransferred: ").append(bytesTransferred()).append(",");
        }
        if (objectsTransferred() != null) {
            sb.append("ObjectsTransferred: ").append(objectsTransferred()).append(",");
        }
        if (totalBytes() != null) {
            sb.append("TotalBytes: ").append(totalBytes()).append(",");
        }
        if (totalObjects() != null) {
            sb.append("TotalObjects: ").append(totalObjects()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BytesTransferred":
            return Optional.of(clazz.cast(bytesTransferred()));
        case "ObjectsTransferred":
            return Optional.of(clazz.cast(objectsTransferred()));
        case "TotalBytes":
            return Optional.of(clazz.cast(totalBytes()));
        case "TotalObjects":
            return Optional.of(clazz.cast(totalObjects()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataTransferMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DataTransfer> {
        /**
         * <p>
         * The number of bytes transferred between a Snowball and Amazon S3.
         * </p>
         * 
         * @param bytesTransferred
         *        The number of bytes transferred between a Snowball and Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesTransferred(Long bytesTransferred);

        /**
         * <p>
         * The number of objects transferred between a Snowball and Amazon S3.
         * </p>
         * 
         * @param objectsTransferred
         *        The number of objects transferred between a Snowball and Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectsTransferred(Long objectsTransferred);

        /**
         * <p>
         * The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until
         * all the keys that will be transferred have been listed.
         * </p>
         * 
         * @param totalBytes
         *        The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero)
         *        until all the keys that will be transferred have been listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBytes(Long totalBytes);

        /**
         * <p>
         * The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero)
         * until all the keys that will be transferred have been listed.
         * </p>
         * 
         * @param totalObjects
         *        The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0
         *        (zero) until all the keys that will be transferred have been listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalObjects(Long totalObjects);
    }

    static final class BuilderImpl implements Builder {
        private Long bytesTransferred;

        private Long objectsTransferred;

        private Long totalBytes;

        private Long totalObjects;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransfer model) {
            bytesTransferred(model.bytesTransferred);
            objectsTransferred(model.objectsTransferred);
            totalBytes(model.totalBytes);
            totalObjects(model.totalObjects);
        }

        public final Long getBytesTransferred() {
            return bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        public final Long getObjectsTransferred() {
            return objectsTransferred;
        }

        @Override
        public final Builder objectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
            return this;
        }

        public final void setObjectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
        }

        public final Long getTotalBytes() {
            return totalBytes;
        }

        @Override
        public final Builder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public final void setTotalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
        }

        public final Long getTotalObjects() {
            return totalObjects;
        }

        @Override
        public final Builder totalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
            return this;
        }

        public final void setTotalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
        }

        @Override
        public DataTransfer build() {
            return new DataTransfer(this);
        }
    }
}
