/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetJobManifestResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetJobManifestResponse.Builder, GetJobManifestResponse> {
    private final String manifestURI;

    private GetJobManifestResponse(BuilderImpl builder) {
        this.manifestURI = builder.manifestURI;
    }

    /**
     * <p>
     * The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.
     * </p>
     * 
     * @return The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.
     */
    public String manifestURI() {
        return manifestURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((manifestURI() == null) ? 0 : manifestURI().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobManifestResponse)) {
            return false;
        }
        GetJobManifestResponse other = (GetJobManifestResponse) obj;
        if (other.manifestURI() == null ^ this.manifestURI() == null) {
            return false;
        }
        if (other.manifestURI() != null && !other.manifestURI().equals(this.manifestURI())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (manifestURI() != null) {
            sb.append("ManifestURI: ").append(manifestURI()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestURI":
            return Optional.of(clazz.cast(manifestURI()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetJobManifestResponse> {
        /**
         * <p>
         * The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.
         * </p>
         * 
         * @param manifestURI
         *        The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestURI(String manifestURI);
    }

    static final class BuilderImpl implements Builder {
        private String manifestURI;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobManifestResponse model) {
            manifestURI(model.manifestURI);
        }

        public final String getManifestURI() {
            return manifestURI;
        }

        @Override
        public final Builder manifestURI(String manifestURI) {
            this.manifestURI = manifestURI;
            return this;
        }

        public final void setManifestURI(String manifestURI) {
            this.manifestURI = manifestURI;
        }

        @Override
        public GetJobManifestResponse build() {
            return new GetJobManifestResponse(this);
        }
    }
}
