/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateJobRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateJobRequest.Builder, UpdateJobRequest> {
    private final String jobId;

    private final String roleARN;

    private final Notification notification;

    private final JobResource resources;

    private final String addressId;

    private final String shippingOption;

    private final String description;

    private final String snowballCapacityPreference;

    private final String forwardingAddressId;

    private UpdateJobRequest(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.roleARN = builder.roleARN;
        this.notification = builder.notification;
        this.resources = builder.resources;
        this.addressId = builder.addressId;
        this.shippingOption = builder.shippingOption;
        this.description = builder.description;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The job ID of the job that you want to update, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the
     * <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS Identity and
     * Access Management (IAM) API action.
     * </p>
     * 
     * @return The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN,
     *         use the <a
     *         href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS Identity
     *         and Access Management (IAM) API action.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The new or updated <a>Notification</a> object.
     * </p>
     * 
     * @return The new or updated <a>Notification</a> object.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The updated <a>S3Resource</a> object (for a single Amazon S3 bucket or key range), or the updated
     * <a>JobResource</a> object (for multiple buckets or key ranges).
     * </p>
     * 
     * @return The updated <a>S3Resource</a> object (for a single Amazon S3 bucket or key range), or the updated
     *         <a>JobResource</a> object (for multiple buckets or key ranges).
     */
    public JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * The ID of the updated <a>Address</a> object.
     * </p>
     * 
     * @return The ID of the updated <a>Address</a> object.
     */
    public String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionString}.
     * </p>
     * 
     * @return The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * @see ShippingOption
     */
    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(shippingOption);
    }

    /**
     * <p>
     * The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionString}.
     * </p>
     * 
     * @return The updated shipping option value of this job's <a>ShippingDetails</a> object.
     * @see ShippingOption
     */
    public String shippingOptionString() {
        return shippingOption;
    }

    /**
     * <p>
     * The updated description of this job's <a>JobMetadata</a> object.
     * </p>
     * 
     * @return The updated description of this job's <a>JobMetadata</a> object.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB Snowballs
     * are only available in the US regions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceString}.
     * </p>
     * 
     * @return The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
     *         Snowballs are only available in the US regions.
     * @see SnowballCapacity
     */
    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(snowballCapacityPreference);
    }

    /**
     * <p>
     * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB Snowballs
     * are only available in the US regions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snowballCapacityPreference} will return {@link SnowballCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #snowballCapacityPreferenceString}.
     * </p>
     * 
     * @return The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
     *         Snowballs are only available in the US regions.
     * @see SnowballCapacity
     */
    public String snowballCapacityPreferenceString() {
        return snowballCapacityPreference;
    }

    /**
     * <p>
     * The updated ID for the forwarding address for a job. This field is not supported in most regions.
     * </p>
     * 
     * @return The updated ID for the forwarding address for a job. This field is not supported in most regions.
     */
    public String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobId() == null) ? 0 : jobId().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((resources() == null) ? 0 : resources().hashCode());
        hashCode = 31 * hashCode + ((addressId() == null) ? 0 : addressId().hashCode());
        hashCode = 31 * hashCode + ((shippingOptionString() == null) ? 0 : shippingOptionString().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode
                + ((snowballCapacityPreferenceString() == null) ? 0 : snowballCapacityPreferenceString().hashCode());
        hashCode = 31 * hashCode + ((forwardingAddressId() == null) ? 0 : forwardingAddressId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobRequest)) {
            return false;
        }
        UpdateJobRequest other = (UpdateJobRequest) obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.shippingOptionString() == null ^ this.shippingOptionString() == null) {
            return false;
        }
        if (other.shippingOptionString() != null && !other.shippingOptionString().equals(this.shippingOptionString())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.snowballCapacityPreferenceString() == null ^ this.snowballCapacityPreferenceString() == null) {
            return false;
        }
        if (other.snowballCapacityPreferenceString() != null
                && !other.snowballCapacityPreferenceString().equals(this.snowballCapacityPreferenceString())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        if (other.forwardingAddressId() != null && !other.forwardingAddressId().equals(this.forwardingAddressId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobId() != null) {
            sb.append("JobId: ").append(jobId()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (resources() != null) {
            sb.append("Resources: ").append(resources()).append(",");
        }
        if (addressId() != null) {
            sb.append("AddressId: ").append(addressId()).append(",");
        }
        if (shippingOptionString() != null) {
            sb.append("ShippingOption: ").append(shippingOptionString()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (snowballCapacityPreferenceString() != null) {
            sb.append("SnowballCapacityPreference: ").append(snowballCapacityPreferenceString()).append(",");
        }
        if (forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(forwardingAddressId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.of(clazz.cast(jobId()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "Notification":
            return Optional.of(clazz.cast(notification()));
        case "Resources":
            return Optional.of(clazz.cast(resources()));
        case "AddressId":
            return Optional.of(clazz.cast(addressId()));
        case "ShippingOption":
            return Optional.of(clazz.cast(shippingOptionString()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "SnowballCapacityPreference":
            return Optional.of(clazz.cast(snowballCapacityPreferenceString()));
        case "ForwardingAddressId":
            return Optional.of(clazz.cast(forwardingAddressId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateJobRequest> {
        /**
         * <p>
         * The job ID of the job that you want to update, for example
         * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The job ID of the job that you want to update, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use
         * the <a href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS
         * Identity and Access Management (IAM) API action.
         * </p>
         * 
         * @param roleARN
         *        The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role
         *        ARN, use the <a
         *        href="http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS
         *        Identity and Access Management (IAM) API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The new or updated <a>Notification</a> object.
         * </p>
         * 
         * @param notification
         *        The new or updated <a>Notification</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The updated <a>S3Resource</a> object (for a single Amazon S3 bucket or key range), or the updated
         * <a>JobResource</a> object (for multiple buckets or key ranges).
         * </p>
         * 
         * @param resources
         *        The updated <a>S3Resource</a> object (for a single Amazon S3 bucket or key range), or the updated
         *        <a>JobResource</a> object (for multiple buckets or key ranges).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * The ID of the updated <a>Address</a> object.
         * </p>
         * 
         * @param addressId
         *        The ID of the updated <a>Address</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * </p>
         * 
         * @param shippingOption
         *        The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * </p>
         * 
         * @param shippingOption
         *        The updated shipping option value of this job's <a>ShippingDetails</a> object.
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * The updated description of this job's <a>JobMetadata</a> object.
         * </p>
         * 
         * @param description
         *        The updated description of this job's <a>JobMetadata</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         * Snowballs are only available in the US regions.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         *        Snowballs are only available in the US regions.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(String snowballCapacityPreference);

        /**
         * <p>
         * The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         * Snowballs are only available in the US regions.
         * </p>
         * 
         * @param snowballCapacityPreference
         *        The updated <code>SnowballCapacityPreference</code> of this job's <a>JobMetadata</a> object. The 50 TB
         *        Snowballs are only available in the US regions.
         * @see SnowballCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowballCapacity
         */
        Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference);

        /**
         * <p>
         * The updated ID for the forwarding address for a job. This field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The updated ID for the forwarding address for a job. This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String roleARN;

        private Notification notification;

        private JobResource resources;

        private String addressId;

        private String shippingOption;

        private String description;

        private String snowballCapacityPreference;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobRequest model) {
            jobId(model.jobId);
            roleARN(model.roleARN);
            notification(model.notification);
            resources(model.resources);
            addressId(model.addressId);
            shippingOption(model.shippingOption);
            description(model.description);
            snowballCapacityPreference(model.snowballCapacityPreference);
            forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final JobResource.Builder getResources() {
            return resources != null ? resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getAddressId() {
            return addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSnowballCapacityPreference() {
            return snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }
    }
}
