/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.snowball.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ClusterMetadata JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ClusterMetadataUnmarshaller implements Unmarshaller<ClusterMetadata, JsonUnmarshallerContext> {

    public ClusterMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        ClusterMetadata.Builder clusterMetadataBuilder = ClusterMetadata.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ClusterId", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.clusterId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KmsKeyARN", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.kmsKeyARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.roleARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ClusterState", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.clusterState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("JobType", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.jobType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SnowballType", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.snowballType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Resources", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.resources(JobResourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AddressId", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.addressId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ShippingOption", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.shippingOption(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Notification", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.notification(NotificationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ForwardingAddressId", targetDepth)) {
                    context.nextToken();
                    clusterMetadataBuilder.forwardingAddressId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return clusterMetadataBuilder.build();
    }

    private static final ClusterMetadataUnmarshaller INSTANCE = new ClusterMetadataUnmarshaller();

    public static ClusterMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}
