/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListClusterJobsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListClusterJobsResponse.Builder, ListClusterJobsResponse> {
    private final List<JobListEntry> jobListEntries;

    private final String nextToken;

    private ListClusterJobsResponse(BuilderImpl builder) {
        this.jobListEntries = builder.jobListEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the
     * job is a job part, in the case of export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
     *         whether the job is a job part, in the case of export jobs.
     */
    public List<JobListEntry> jobListEntries() {
        return jobListEntries;
    }

    /**
     * <p>
     * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
     * <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.
     * </p>
     * 
     * @return HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your
     *         next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in
     *         the array.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobListEntries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterJobsResponse)) {
            return false;
        }
        ListClusterJobsResponse other = (ListClusterJobsResponse) obj;
        return Objects.equals(jobListEntries(), other.jobListEntries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobListEntries() != null) {
            sb.append("JobListEntries: ").append(jobListEntries()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobListEntries":
            return Optional.of(clazz.cast(jobListEntries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListClusterJobsResponse> {
        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * 
         * @param jobListEntries
         *        Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
         *        whether the job is a job part, in the case of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(Collection<JobListEntry> jobListEntries);

        /**
         * <p>
         * Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether
         * the job is a job part, in the case of export jobs.
         * </p>
         * 
         * @param jobListEntries
         *        Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates
         *        whether the job is a job part, in the case of export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobListEntries(JobListEntry... jobListEntries);

        /**
         * <p>
         * HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next
         * <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.
         * </p>
         * 
         * @param nextToken
         *        HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in
         *        your next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this
         *        point in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<JobListEntry> jobListEntries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterJobsResponse model) {
            jobListEntries(model.jobListEntries);
            nextToken(model.nextToken);
        }

        public final Collection<JobListEntry.Builder> getJobListEntries() {
            return jobListEntries != null ? jobListEntries.stream().map(JobListEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder jobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(JobListEntry... jobListEntries) {
            jobListEntries(Arrays.asList(jobListEntries));
            return this;
        }

        public final void setJobListEntries(Collection<JobListEntry.BuilderImpl> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copyFromBuilder(jobListEntries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClusterJobsResponse build() {
            return new ListClusterJobsResponse(this);
        }
    }
}
